#version 120
/* DRAWBUFFERS:526 */
/*
                            _____ _____ ___________
                           /  ___|_   _|  _  | ___ \
                           \ `--.  | | | | | | |_/ /
                            `--. \ | | | | | |  __/
                           /\__/ / | | \ \_/ / |
                           \____/  \_/  \___/\_|
						Sildur's vibrant shaders v1.16 and newer
						Before editing anything here make sure you've
						read The agreement, which you accepted by downloading
						my shaderpack. The agreement can be found here:
			http://www.minecraftforum.net/topic/1953873-164-172-sildurs-shaders-pcmacintel/

*/
#define SHADOW_MAP_BIAS 0.80
const float shadowMapResolution = 3072;		//set to same as main shadowres [512 1024 2048 3072 4096 8192]

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec4 ambientNdotL;
varying vec3 sunlight;
varying float skyL;

varying vec3 normal;
varying mat3 tbnMatrix;
varying float NdotL;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform sampler2D noisetex;
uniform sampler2D texture;
uniform sampler2DShadow shadow;

uniform vec3 cameraPosition;

uniform float frameTimeCounter;
uniform float viewWidth;
uniform float viewHeight;
uniform ivec2 eyeBrightnessSmooth;

float noisetexture(vec2 coord, float offset, float speed){
return texture2D(noisetex, fract(coord*offset + frameTimeCounter*speed)).x/offset;
}

float noiseW(vec3 pos){
	vec2 coord = (pos.xz / 2000.0);
	
	float noise = noisetexture(coord, 0.5, 0.00225);
		  noise -= noisetexture(coord, 0.5, -0.00225);
		  noise += noisetexture(coord, 2.0, 0.003375);
		  noise -= noisetexture(coord, 2.0, -0.003375);
		  noise += noisetexture(coord, 3.5, 0.0045);
		  noise -= noisetexture(coord, 3.5, -0.0045);

	return noise;
}

vec4 encode (vec3 n,float dif){
    float p = sqrt(n.z*8+8);
	
	float vis = lmcoord.t;
	if (ambientNdotL.a > 0.9) vis = vis / 4.0;
	if (ambientNdotL.a > 0.4 && ambientNdotL.a < 0.6) vis = vis/4.0+0.25;
	if (ambientNdotL.a < 0.1) vis = vis/4.0+0.5;	
	
    return vec4(n.xy/p + 0.5,vis,1.0);
}


void main() {

	float iswater = ambientNdotL.a;
	float diffuse = NdotL;

	vec4 albedo = texture2D(texture, texcoord.xy)*color;
	albedo.rgb = pow(albedo.rgb,vec3(2.2));
	
	vec4 fragposition = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0);
	fragposition /= fragposition.w;	
	vec4 worldposition = gbufferModelViewInverse * fragposition;

//only apply shading to blocks with a lower alpha than 1.0 (=transparent)
if (albedo.a < 1.0 && diffuse > 0.0 && iswater < 0.9){
	worldposition = shadowModelView * worldposition;
	worldposition = shadowProjection * worldposition;
	vec2 pos = abs(worldposition.xy * 1.165);
	float distb = pow(pow(pos.x, 12.0) + pow(pos.y, 12.0), 0.083);
	float distortFactor = (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	worldposition.xy /= distortFactor*0.97; 

	if (max(abs(worldposition.x),abs(worldposition.y)) < 0.99) {
		const float diffthresh = 0.0004;
		worldposition = worldposition * vec4(0.5,0.5,0.2,0.5) + vec4(0.5,0.5,0.5-diffthresh,0.5);
	
		//Fast and simple shadow drawing for proper rendering of translucent blocks
		diffuse *= shadow2D(shadow,vec3(worldposition.st, worldposition.z)).x;
	}
	diffuse *= mix(skyL,1.0,clamp((eyeBrightnessSmooth.y/255.0-2.0/16.)*4.0,0.0,1.0)); //avoid light leaking underground
}

vec3 newnormal = normal;
if (iswater > 0.9){
	albedo.rgb = mix(albedo.rgb,vec3(0.0, 0.6, 0.8),0.7);
	
	vec3 waterpos = worldposition.xyz+cameraPosition;
		 waterpos.xz *= 7.0;
	
	const float deltaPos = 0.4;
	float h0 = noiseW(waterpos);
	float h1 = noiseW(waterpos + vec3(deltaPos,0.0,0.0));
	float h2 = noiseW(waterpos + vec3(-deltaPos,0.0,0.0));
	float h3 = noiseW(waterpos + vec3(0.0,0.0,deltaPos));
	float h4 = noiseW(waterpos + vec3(0.0,0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	//Bump mapping
	const float bumpmult = 0.03;
	vec3 bump = vec3(xDelta,yDelta,1.0-xDelta*xDelta-yDelta*yDelta);
		 bump = bump * vec3(bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);

		newnormal = vec3(normalize(bump * tbnMatrix));
}

	vec3 sunlightC = (1.0-iswater)*sunlight.rgb*clamp(diffuse,0.0,1.0);
	vec3 finalColor = albedo.rgb*(sunlightC+ambientNdotL.rgb);
	float alpha = mix(albedo.a,0.11,max(iswater*2.0-1.0,0.0));

	gl_FragData[0] = vec4(finalColor, alpha);
	gl_FragData[1] = encode(newnormal.xyz, diffuse);
	gl_FragData[2] = vec4(normalize(albedo.rgb+0.00001), alpha);
}