/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.google.gson.Gson;
import com.teamderpy.shouldersurfing.asm.ShoulderASMHelper;
import com.teamderpy.shouldersurfing.json.JsonShoulderSurfing;
import com.teamderpy.shouldersurfing.util.Util;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@SideOnly(value=Side.CLIENT)
public class ShoulderTransformations
implements IClassTransformer {
    private final HashMap<String, JsonShoulderSurfing.JsonVersions.JsonMappings.JsonMapping> mappings = new HashMap();
    public static final int CODE_MODIFICATIONS = 3;
    public static int modifications = 0;

    public ShoulderTransformations() {
        String version = "1.12";
        JsonShoulderSurfing json = new JsonShoulderSurfing();
        try {
            version = ForgeVersion.class.getDeclaredField("mcVersion").get(ForgeVersion.class).toString();
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("assets/shouldersurfing/mappings/mappings.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            json = (JsonShoulderSurfing)new Gson().fromJson((Reader)reader, JsonShoulderSurfing.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (JsonShoulderSurfing.JsonVersions versions : json.getVersions()) {
            if (!versions.getVersion().equals(version)) continue;
            for (JsonShoulderSurfing.JsonVersions.JsonMappings.JsonMapping clazz : versions.getMappings().getClasses()) {
                this.mappings.put(clazz.getName() + "Class", clazz);
            }
            for (JsonShoulderSurfing.JsonVersions.JsonMappings.JsonMapping method : versions.getMappings().getMethods()) {
                this.mappings.put(method.getName() + "Method", method);
            }
            for (JsonShoulderSurfing.JsonVersions.JsonMappings.JsonMapping field : versions.getMappings().getFields()) {
                this.mappings.put(field.getName() + "Field", field);
            }
            Util.LOGGER.info("Loaded mappings for Minecraft " + versions.getVersion());
            return;
        }
        Util.LOGGER.error("No mappings found for Minecraft 1.12");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equals(this.mappings.get("EntityRendererClass").getObf())) {
            Util.LOGGER.info("Injecting into obfuscated code - EntityRendererClass");
            return this.transformEntityRenderClass(bytes, true);
        }
        if (name.equals(this.mappings.get("EntityRendererClass").getPackage())) {
            Util.LOGGER.info("Injecting into non-obfuscated code - EntityRendererClass");
            return this.transformEntityRenderClass(bytes, false);
        }
        return bytes;
    }

    private byte[] transformEntityRenderClass(byte[] bytes, boolean isObfuscated) {
        Util.LOGGER.info("Attempting class transformation against EntityRender");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            InsnList searchList;
            if (m.name.equals(this.mappings.get("orientCameraMethod").getFieldOrMethod(isObfuscated)) && m.desc.equals(this.mappings.get("orientCameraMethod").getDescriptor())) {
                Util.LOGGER.info("Located method " + m.name + m.desc + ", locating signature");
                searchList = new InsnList();
                searchList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                searchList.add((AbstractInsnNode)new FieldInsnNode(180, this.mappings.get("EntityClass").getClassPath(isObfuscated), this.mappings.get("rotationYawField").getFieldOrMethod(isObfuscated), this.mappings.get("rotationYawField").getDescriptor()));
                searchList.add((AbstractInsnNode)new VarInsnNode(56, 12));
                searchList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                searchList.add((AbstractInsnNode)new FieldInsnNode(180, this.mappings.get("EntityClass").getClassPath(isObfuscated), this.mappings.get("rotationPitchField").getFieldOrMethod(isObfuscated), this.mappings.get("rotationPitchField").getDescriptor()));
                searchList.add((AbstractInsnNode)new VarInsnNode(56, 13));
                int offset = ShoulderASMHelper.locateOffset(m.instructions, searchList);
                if (offset == -1) {
                    Util.LOGGER.error("Failed to locate first of two offsets in " + m.name + m.desc + "! Is base file changed?");
                    return bytes;
                }
                Util.LOGGER.info("Located offset @ " + offset);
                InsnList hackCode = new InsnList();
                hackCode.add((AbstractInsnNode)new VarInsnNode(23, 12));
                hackCode.add((AbstractInsnNode)new MethodInsnNode(184, this.mappings.get("InjectionDelegationClass").getClassPath(isObfuscated), "getShoulderRotation", "()F", false));
                hackCode.add((AbstractInsnNode)new InsnNode(98));
                hackCode.add((AbstractInsnNode)new VarInsnNode(56, 12));
                hackCode.add((AbstractInsnNode)new VarInsnNode(24, 10));
                hackCode.add((AbstractInsnNode)new MethodInsnNode(184, this.mappings.get("InjectionDelegationClass").getClassPath(isObfuscated), "getShoulderZoomMod", "()F", false));
                hackCode.add((AbstractInsnNode)new InsnNode(141));
                hackCode.add((AbstractInsnNode)new InsnNode(107));
                hackCode.add((AbstractInsnNode)new VarInsnNode(57, 10));
                hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
                m.instructions.insertBefore(m.instructions.get(offset + 1), hackCode);
                Util.LOGGER.info("Injected code for camera orientation!");
                ++modifications;
                searchList = new InsnList();
                searchList.add((AbstractInsnNode)new VarInsnNode(57, 25));
                searchList.add((AbstractInsnNode)new VarInsnNode(24, 25));
                offset = ShoulderASMHelper.locateOffset(m.instructions, searchList);
                if (offset == -1) {
                    Util.LOGGER.error("Failed to locate second of two offsets in " + m.name + m.desc + "! Is base file changed?");
                    return bytes;
                }
                Util.LOGGER.info("Located offset @ " + offset);
                hackCode = new InsnList();
                hackCode.add((AbstractInsnNode)new VarInsnNode(24, 25));
                hackCode.add((AbstractInsnNode)new MethodInsnNode(184, this.mappings.get("InjectionDelegationClass").getClassPath(isObfuscated), "verifyReverseBlockDist", "(D)V", false));
                hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
                m.instructions.insertBefore(m.instructions.get(offset), hackCode);
                Util.LOGGER.info("Injected code for camera distance check!");
                ++modifications;
                continue;
            }
            if (!m.name.equals(this.mappings.get("renderWorldPassMethod").getFieldOrMethod(isObfuscated)) || !m.desc.equals(this.mappings.get("renderWorldPassMethod").getDescriptor())) continue;
            Util.LOGGER.info("Located method " + m.name + m.desc + ", locating signature");
            searchList = new InsnList();
            searchList.add((AbstractInsnNode)new MethodInsnNode(184, this.mappings.get("ClippingHelperImplClass").getClassPath(isObfuscated), this.mappings.get("getInstanceMethod").getFieldOrMethod(isObfuscated), this.mappings.get("getInstanceMethod").getDescriptor() + this.mappings.get("ClippingHelperClass").getClassPath(isObfuscated) + ";", false));
            searchList.add((AbstractInsnNode)new InsnNode(87));
            InsnList searchListOptifine = new InsnList();
            searchListOptifine.add((AbstractInsnNode)new MethodInsnNode(184, this.mappings.get("ClippingHelperImplClass").getClassPath(isObfuscated), this.mappings.get("getInstanceMethod").getFieldOrMethod(isObfuscated), this.mappings.get("getInstanceMethod").getDescriptor() + this.mappings.get("ClippingHelperClass").getClassPath(isObfuscated) + ";", false));
            searchListOptifine.add((AbstractInsnNode)new VarInsnNode(58, 9));
            int offset = -1;
            int offsetVanilla = ShoulderASMHelper.locateOffset(m.instructions, searchList);
            int offsetOptifine = ShoulderASMHelper.locateOffset(m.instructions, searchListOptifine);
            if (offsetVanilla != -1) {
                offset = offsetVanilla;
            } else if (offsetOptifine != -1) {
                offset = offsetOptifine;
                Util.LOGGER.info("Optifine detected");
            }
            if (offset == -1) {
                Util.LOGGER.error("Failed to locate offset in " + m.name + m.desc + "! Is base file changed?");
                return bytes;
            }
            Util.LOGGER.info("Located offset @ " + offset);
            InsnList hackCode = new InsnList();
            hackCode.add((AbstractInsnNode)new MethodInsnNode(184, this.mappings.get("InjectionDelegationClass").getClassPath(isObfuscated), "calculateRayTraceProjection", "()V", false));
            hackCode.add((AbstractInsnNode)new LabelNode(new Label()));
            m.instructions.insertBefore(m.instructions.get(offset + 1), hackCode);
            Util.LOGGER.info("Injected code for ray trace projection!");
            ++modifications;
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

