/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing;

import com.teamderpy.shouldersurfing.ShoulderCamera;
import com.teamderpy.shouldersurfing.ShoulderSettings;
import com.teamderpy.shouldersurfing.ShoulderSurfing;
import com.teamderpy.shouldersurfing.math.RayTracer;
import com.teamderpy.shouldersurfing.renderer.ShoulderRenderBin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShoulderEventHandler {
    private static float lastX = 0.0f;
    private static float lastY = 0.0f;

    @SubscribeEvent
    public void renderEvent(TickEvent.RenderTickEvent event) {
        ShoulderRenderBin.skipPlayerRender = false;
        RayTracer.traceFromEyes(1.0f);
        if (ShoulderRenderBin.rayTraceHit != null && Minecraft.func_71410_x().field_71439_g != null) {
            ShoulderRenderBin.rayTraceHit = ShoulderRenderBin.rayTraceHit.func_178788_d(new Vec3d(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v));
        }
    }

    @SubscribeEvent
    public void keyPressed(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71462_r == null && Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
            if (ShoulderSurfing.KEYBIND_ROTATE_CAMERA_LEFT.func_151470_d()) {
                ShoulderCamera.adjustCameraLeft();
            } else if (ShoulderSurfing.KEYBIND_ROTATE_CAMERA_RIGHT.func_151470_d()) {
                ShoulderCamera.adjustCameraRight();
            } else if (ShoulderSurfing.KEYBIND_ZOOM_CAMERA_IN.func_151470_d()) {
                ShoulderCamera.adjustCameraIn();
            } else if (ShoulderSurfing.KEYBIND_ZOOM_CAMERA_OUT.func_151470_d()) {
                ShoulderCamera.adjustCameraOut();
            } else {
                return;
            }
            ShoulderSurfing.config.get("general", "Rotation Offset", (double)ShoulderCamera.SHOULDER_ROTATION, "Third person camera rotation").set((double)ShoulderCamera.SHOULDER_ROTATION);
            ShoulderSurfing.config.get("general", "Zoom Offset", (double)ShoulderCamera.SHOULDER_ZOOM_MOD, "Third person camera zoom").set((double)ShoulderCamera.SHOULDER_ZOOM_MOD);
            ShoulderSurfing.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("shouldersurfing")) {
            ShoulderSurfing.syncConfig();
        }
    }

    @SubscribeEvent
    public void postRenderCrosshairs(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
    }

    @SubscribeEvent
    public void preRenderPlayer(RenderPlayerEvent.Pre event) {
        if (ShoulderRenderBin.skipPlayerRender && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preRenderCrosshairs(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            float tick = event.getPartialTicks();
            GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
            ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
            int width = resolution.func_78326_a();
            int height = resolution.func_78328_b();
            int scale = resolution.func_78325_e();
            if (Minecraft.func_71410_x().field_71474_y.field_74330_P && !Minecraft.func_71410_x().field_71474_y.field_74319_N && !Minecraft.func_71410_x().field_71439_g.func_175140_cp() && !Minecraft.func_71410_x().field_71474_y.field_178879_v) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(width / 2), (float)(height / 2), (float)300.0f);
                Entity entity = Minecraft.func_71410_x().func_175606_aa();
                GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * (float)scale), (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * (float)scale), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                OpenGlHelper.func_188785_m((int)10);
                GlStateManager.func_179121_F();
            } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 || !ShoulderSettings.IS_DYNAMIC_CROSSHAIR_ENABLED && Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
                lastX = width * scale / 2;
                lastY = height * scale / 2;
                this.renderCrosshair(gui, resolution);
            } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1) {
                GlStateManager.func_179094_E();
                float diffX = ((float)(width * scale / 2) - lastX) * tick;
                float diffY = ((float)(height * scale / 2) - lastY) * tick;
                if (ShoulderRenderBin.projectedVector != null) {
                    diffX = (ShoulderRenderBin.projectedVector.x - lastX) * tick;
                    diffY = (ShoulderRenderBin.projectedVector.y - lastY) * tick;
                }
                float crosshairWidth = (lastX + diffX) / (float)scale - 7.0f;
                float crosshairHeight = (lastY + diffY) / (float)scale - 7.0f;
                GlStateManager.func_179152_a((float)(1.0f / (float)scale), (float)(1.0f / (float)scale), (float)(1.0f / (float)scale));
                GlStateManager.func_179109_b((float)(crosshairWidth * (float)scale), (float)(crosshairHeight * (float)scale), (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179109_b((float)(-width / 2 + 7), (float)(-height / 2 + 7), (float)0.0f);
                this.renderCrosshair(gui, resolution);
                lastX += diffX;
                lastY += diffY;
                GlStateManager.func_179121_F();
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    private void renderCrosshair(GuiIngame gui, ScaledResolution resolution) {
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179141_d();
        gui.func_73729_b(width / 2 - 7, height / 2 - 7, 0, 0, 16, 16);
        if (Minecraft.func_71410_x().field_71474_y.field_186716_M == 1) {
            float cooledAttackStrength = Minecraft.func_71410_x().field_71439_g.func_184825_o(0.0f);
            boolean flag = false;
            if (Minecraft.func_71410_x().field_147125_j != null && Minecraft.func_71410_x().field_147125_j instanceof EntityLivingBase && cooledAttackStrength >= 1.0f) {
                flag = Minecraft.func_71410_x().field_71439_g.func_184818_cX() > 5.0f;
                flag &= ((EntityLivingBase)Minecraft.func_71410_x().field_147125_j).func_70089_S();
            }
            int y = height / 2 - 7 + 16;
            int x = width / 2 - 8;
            if (flag) {
                gui.func_73729_b(x, y, 68, 94, 16, 16);
            } else if (cooledAttackStrength < 1.0f) {
                int offset = (int)(cooledAttackStrength * 17.0f);
                gui.func_73729_b(x, y, 36, 94, 16, 4);
                gui.func_73729_b(x, y, 52, 94, offset, 4);
            }
        }
        GlStateManager.func_179084_k();
    }
}

