/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import shadersmod.client.BlockAlias;
import shadersmod.client.IShaderPack;

public class BlockAliases {
    private static BlockAlias[][] blockAliases = null;

    public static int getMappedBlockId(int blockId, int metadata) {
        if (blockAliases == null) {
            return blockId;
        }
        if (blockId < 0 || blockId >= blockAliases.length) {
            return blockId;
        }
        BlockAlias[] aliases = blockAliases[blockId];
        if (aliases == null) {
            return blockId;
        }
        for (int i2 = 0; i2 < aliases.length; ++i2) {
            BlockAlias ba = aliases[i2];
            if (!ba.matches(blockId, metadata)) continue;
            return ba.getBlockId();
        }
        return blockId;
    }

    public static void update(IShaderPack shaderPack) {
        BlockAliases.reset();
        String path = "/shaders/block.properties";
        try {
            InputStream in = shaderPack.getResourceAsStream(path);
            if (in == null) {
                return;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg("[Shaders] Parsing block mappings: " + path);
            ArrayList<List<BlockAlias>> listBlockAliases = new ArrayList<List<BlockAlias>>();
            ConnectedParser cp = new ConnectedParser("Shaders");
            Set<Object> keys = ((Properties)props).keySet();
            for (String string : keys) {
                String val = props.getProperty(string);
                String prefix = "block.";
                if (!string.startsWith(prefix)) {
                    Config.warn("[Shaders] Invalid block ID: " + string);
                    continue;
                }
                String blockIdStr = StrUtils.removePrefix(string, prefix);
                int blockId = Config.parseInt(blockIdStr, -1);
                if (blockId < 0) {
                    Config.warn("[Shaders] Invalid block ID: " + string);
                    continue;
                }
                MatchBlock[] matchBlocks = cp.parseMatchBlocks(val);
                if (matchBlocks == null || matchBlocks.length < 1) {
                    Config.warn("[Shaders] Invalid block ID mapping: " + string + "=" + val);
                    continue;
                }
                BlockAlias ba = new BlockAlias(blockId, matchBlocks);
                BlockAliases.addToList(listBlockAliases, ba);
            }
            if (listBlockAliases.size() <= 0) {
                return;
            }
            blockAliases = BlockAliases.toArrays(listBlockAliases);
        }
        catch (IOException e2) {
            Config.warn("[Shaders] Error reading: " + path);
        }
    }

    private static void addToList(List<List<BlockAlias>> blocksAliases, BlockAlias ba) {
        int[] blockIds = ba.getMatchBlockIds();
        for (int i2 = 0; i2 < blockIds.length; ++i2) {
            int blockId = blockIds[i2];
            while (blockId >= blocksAliases.size()) {
                blocksAliases.add(null);
            }
            List<BlockAlias> blockAliases = blocksAliases.get(blockId);
            if (blockAliases == null) {
                blockAliases = new ArrayList<BlockAlias>();
                blocksAliases.set(blockId, blockAliases);
            }
            blockAliases.add(ba);
        }
    }

    private static BlockAlias[][] toArrays(List<List<BlockAlias>> listBlocksAliases) {
        BlockAlias[][] bas = new BlockAlias[listBlocksAliases.size()][];
        for (int i2 = 0; i2 < bas.length; ++i2) {
            List<BlockAlias> listBlockAliases = listBlocksAliases.get(i2);
            if (listBlockAliases == null) continue;
            bas[i2] = listBlockAliases.toArray(new BlockAlias[listBlockAliases.size()]);
        }
        return bas;
    }

    public static void reset() {
        blockAliases = null;
    }
}

