/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.optifine.entity.model.anim.Constant;
import net.optifine.entity.model.anim.EnumFunctionType;
import net.optifine.entity.model.anim.EnumTokenType;
import net.optifine.entity.model.anim.Function;
import net.optifine.entity.model.anim.IExpression;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.ParseException;
import net.optifine.entity.model.anim.Token;
import net.optifine.entity.model.anim.TokenParser;

public class ExpressionParser {
    private IModelResolver modelResolver;

    public ExpressionParser(IModelResolver modelResolver) {
        this.modelResolver = modelResolver;
    }

    public IExpression parse(String str) throws ParseException {
        try {
            Token[] tokens = TokenParser.parse(str);
            if (tokens == null) {
                return null;
            }
            ArrayDeque<Token> deque = new ArrayDeque<Token>(Arrays.asList(tokens));
            return this.parseInfix(deque);
        }
        catch (IOException e2) {
            throw new ParseException(e2.getMessage(), e2);
        }
    }

    private IExpression parseInfix(Deque<Token> deque) throws ParseException {
        Token tokenOper;
        if (deque.isEmpty()) {
            return null;
        }
        LinkedList<IExpression> listExpr = new LinkedList<IExpression>();
        LinkedList<Token> listOperTokens = new LinkedList<Token>();
        IExpression expr = this.parseExpression(deque);
        ExpressionParser.checkNull(expr, "Missing expression");
        listExpr.add(expr);
        while ((tokenOper = deque.poll()) != null) {
            if (tokenOper.getType() != EnumTokenType.OPERATOR) {
                throw new ParseException("Invalid operator: " + tokenOper);
            }
            IExpression expr2 = this.parseExpression(deque);
            ExpressionParser.checkNull(expr2, "Missing expression");
            listOperTokens.add(tokenOper);
            listExpr.add(expr2);
        }
        return this.makeInfix(listExpr, listOperTokens);
    }

    private IExpression makeInfix(List<IExpression> listExpr, List<Token> listOper) throws ParseException {
        LinkedList<EnumFunctionType> listFunc = new LinkedList<EnumFunctionType>();
        for (Token token : listOper) {
            EnumFunctionType type = EnumFunctionType.parse(token.getText());
            ExpressionParser.checkNull((Object)type, "Invalid operator: " + token);
            listFunc.add(type);
        }
        return this.makeInfixFunc(listExpr, listFunc);
    }

    private IExpression makeInfixFunc(List<IExpression> listExpr, List<EnumFunctionType> listFunc) throws ParseException {
        if (listExpr.size() != listFunc.size() + 1) {
            throw new ParseException("Invalid infix expression, expressions: " + listExpr.size() + ", operators: " + listFunc.size());
        }
        if (listExpr.size() == 1) {
            return listExpr.get(0);
        }
        int minPrecedence = Integer.MAX_VALUE;
        int maxPrecedence = Integer.MIN_VALUE;
        for (EnumFunctionType type : listFunc) {
            minPrecedence = Math.min(type.getPrecedence(), minPrecedence);
            maxPrecedence = Math.max(type.getPrecedence(), maxPrecedence);
        }
        if (maxPrecedence < minPrecedence || maxPrecedence - minPrecedence > 10) {
            throw new ParseException("Invalid infix precedence, min: " + minPrecedence + ", max: " + maxPrecedence);
        }
        for (int i2 = maxPrecedence; i2 >= minPrecedence; --i2) {
            this.mergeOperators(listExpr, listFunc, i2);
        }
        if (listExpr.size() != 1 || listFunc.size() != 0) {
            throw new ParseException("Error merging operators, expressions: " + listExpr.size() + ", operators: " + listFunc.size());
        }
        return listExpr.get(0);
    }

    private void mergeOperators(List<IExpression> listExpr, List<EnumFunctionType> listFuncs, int precedence) {
        for (int i2 = 0; i2 < listFuncs.size(); ++i2) {
            EnumFunctionType type = listFuncs.get(i2);
            if (type.getPrecedence() != precedence) continue;
            listFuncs.remove(i2);
            IExpression expr1 = listExpr.remove(i2);
            IExpression expr2 = listExpr.remove(i2);
            Function exprOper = new Function(type, new IExpression[]{expr1, expr2});
            listExpr.add(i2, exprOper);
            --i2;
        }
    }

    private IExpression parseExpression(Deque<Token> deque) throws ParseException {
        Token token = deque.poll();
        ExpressionParser.checkNull(token, "Missing expression");
        switch (token.getType()) {
            case CONSTANT: {
                return ExpressionParser.makeConstant(token);
            }
            case IDENTIFIER: {
                EnumFunctionType type = this.getFunctionType(token, deque);
                if (type != null) {
                    return this.makeFunction(type, deque);
                }
                return this.makeVariable(token);
            }
            case BRACKET_OPEN: {
                return this.makeBracketed(token, deque);
            }
            case OPERATOR: {
                EnumFunctionType operType = EnumFunctionType.parse(token.getText());
                ExpressionParser.checkNull((Object)operType, "Invalid operator: " + token);
                if (operType == EnumFunctionType.PLUS) {
                    return this.parseExpression(deque);
                }
                if (operType != EnumFunctionType.MINUS) break;
                IExpression exprNeg = this.parseExpression(deque);
                return new Function(EnumFunctionType.NEG, new IExpression[]{exprNeg});
            }
        }
        throw new ParseException("Invalid expression: " + token);
    }

    private static IExpression makeConstant(Token token) throws ParseException {
        float val = Config.parseFloat(token.getText(), Float.NaN);
        if (val == Float.NaN) {
            throw new ParseException("Invalid float value: " + token);
        }
        return new Constant(val);
    }

    private EnumFunctionType getFunctionType(Token token, Deque<Token> deque) throws ParseException {
        Token tokenNext = deque.peek();
        if (tokenNext != null && tokenNext.getType() == EnumTokenType.BRACKET_OPEN) {
            EnumFunctionType type = EnumFunctionType.parse(token.getText());
            ExpressionParser.checkNull((Object)type, "Unknown function: " + token);
            return type;
        }
        EnumFunctionType type = EnumFunctionType.parse(token.getText());
        if (type == null) {
            return null;
        }
        if (type.getCountArguments() > 0) {
            throw new ParseException("Missing arguments: " + (Object)((Object)type));
        }
        return type;
    }

    private IExpression makeFunction(EnumFunctionType type, Deque<Token> deque) throws ParseException {
        if (type.getCountArguments() == 0) {
            return ExpressionParser.makeFunction(type, new IExpression[0]);
        }
        Token tokenOpen = deque.poll();
        Deque<Token> dequeBracketed = ExpressionParser.getGroup(deque, EnumTokenType.BRACKET_CLOSE, true);
        IExpression[] exprs = this.parseExpressions(dequeBracketed);
        return ExpressionParser.makeFunction(type, exprs);
    }

    private IExpression[] parseExpressions(Deque<Token> deque) throws ParseException {
        Deque<Token> dequeArg;
        IExpression expr;
        ArrayList<IExpression> list = new ArrayList<IExpression>();
        while ((expr = this.parseInfix(dequeArg = ExpressionParser.getGroup(deque, EnumTokenType.COMMA, false))) != null) {
            list.add(expr);
        }
        IExpression[] exprs = list.toArray(new IExpression[list.size()]);
        return exprs;
    }

    private static IExpression makeFunction(EnumFunctionType type, IExpression[] exprs) throws ParseException {
        if (type.getCountArguments() != exprs.length) {
            throw new ParseException("Invalid number of arguments: " + exprs.length + ", should be: " + type.getCountArguments() + ", function: " + type.getName());
        }
        return new Function(type, exprs);
    }

    private IExpression makeVariable(Token token) throws ParseException {
        if (this.modelResolver == null) {
            throw new ParseException("Model variable not found: " + token);
        }
        IExpression expr = this.modelResolver.getExpression(token.getText());
        if (expr == null) {
            throw new ParseException("Model variable not found: " + token);
        }
        return expr;
    }

    private IExpression makeBracketed(Token token, Deque<Token> deque) throws ParseException {
        Deque<Token> dequeBracketed = ExpressionParser.getGroup(deque, EnumTokenType.BRACKET_CLOSE, true);
        return this.parseInfix(dequeBracketed);
    }

    private static Deque<Token> getGroup(Deque<Token> deque, EnumTokenType tokenTypeEnd, boolean tokenEndRequired) throws ParseException {
        ArrayDeque<Token> dequeGroup = new ArrayDeque<Token>();
        int level = 0;
        Iterator<Token> it = deque.iterator();
        while (it.hasNext()) {
            Token token = it.next();
            it.remove();
            if (level == 0 && token.getType() == tokenTypeEnd) {
                return dequeGroup;
            }
            dequeGroup.add(token);
            if (token.getType() == EnumTokenType.BRACKET_OPEN) {
                ++level;
            }
            if (token.getType() != EnumTokenType.BRACKET_CLOSE) continue;
            --level;
        }
        if (tokenEndRequired) {
            throw new ParseException("Missing end token: " + (Object)((Object)tokenTypeEnd));
        }
        return dequeGroup;
    }

    private static void checkNull(Object obj, String message) throws ParseException {
        if (obj == null) {
            throw new ParseException(message);
        }
    }

    public static void main(String[] args) throws Exception {
        ExpressionParser ep = new ExpressionParser(null);
        while (true) {
            try {
                InputStreamReader ir;
                BufferedReader br;
                String line;
                while ((line = (br = new BufferedReader(ir = new InputStreamReader(System.in))).readLine()).length() > 0) {
                    IExpression expr = ep.parse(line);
                    float val = expr.eval();
                    Config.dbg("" + line + " = " + val);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }
}

