/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadersmod.client.ShadersTex;

public class cdn
extends cdd
implements cdt {
    private static final Logger h = LogManager.getLogger();
    public static final nd f = new nd("missingno");
    public static final nd g = new nd("textures/atlas/blocks.png");
    private final List<cdo> i = Lists.newArrayList();
    private final Map<String, cdo> j = Maps.newHashMap();
    private final Map<String, cdo> k = Maps.newHashMap();
    private final String l;
    private final cdg m;
    private int n;
    private final cdo o = new cdo("missingno");
    private cdo[] iconGrid = null;
    private int iconGridSize = -1;
    private int iconGridCountX = -1;
    private int iconGridCountY = -1;
    private double iconGridSizeU = -1.0;
    private double iconGridSizeV = -1.0;
    private int counterIndexInMap = 0;
    public int atlasWidth = 0;
    public int atlasHeight = 0;

    public cdn(String basePathIn) {
        this(basePathIn, null);
    }

    public cdn(String basePathIn, boolean skipFirst) {
        this(basePathIn, null, skipFirst);
    }

    public cdn(String basePathIn, @Nullable cdg iconCreatorIn) {
        this(basePathIn, iconCreatorIn, false);
    }

    public cdn(String basePathIn, cdg iconCreatorIn, boolean skipFirst) {
        this.l = basePathIn;
        this.m = iconCreatorIn;
    }

    private void g() {
        int size = this.getMinSpriteSize();
        int[] aint = this.getMissingImageData(size);
        this.o.b(size);
        this.o.c(size);
        int[][] aint1 = new int[this.n + 1][];
        aint1[0] = aint;
        this.o.a(Lists.newArrayList((Object[])new int[][][]{aint1}));
        this.o.setIndexInMap(this.counterIndexInMap++);
    }

    @Override
    public void a(cen resourceManager) throws IOException {
        ShadersTex.resManager = resourceManager;
        if (this.m != null) {
            this.a(resourceManager, this.m);
        }
    }

    public void a(cen resourceManager, cdg iconCreatorIn) {
        this.j.clear();
        this.counterIndexInMap = 0;
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPre, this);
        iconCreatorIn.a(this);
        if (this.n >= 4) {
            this.n = this.detectMaxMipmapLevel(this.j, resourceManager);
            Config.log("Mipmap levels: " + this.n);
        }
        this.g();
        this.c();
        this.b(resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void b(cen resourceManager) {
        int minSpriteSize;
        ShadersTex.resManager = resourceManager;
        Config.dbg("Multitexture: " + Config.isMultiTexture());
        if (Config.isMultiTexture()) {
            for (cdo ts : this.k.values()) {
                ts.deleteSpriteTexture();
            }
        }
        ConnectedTextures.updateIcons(this);
        CustomItems.updateIcons(this);
        BetterGrass.updateIcons(this);
        int i2 = TextureUtils.getGLMaximumTextureSize();
        cdl stitcher = new cdl(i2, i2, 0, this.n);
        this.k.clear();
        this.i.clear();
        int j2 = Integer.MAX_VALUE;
        this.iconGridSize = minSpriteSize = this.getMinSpriteSize();
        int k2 = 1 << this.n;
        ArrayList<cdo> listRegisteredSprites = new ArrayList<cdo>(this.j.values());
        for (int ix = 0; ix < listRegisteredSprites.size(); ++ix) {
            nd resourcelocation;
            cdo textureatlassprite;
            block38: {
                textureatlassprite = SpriteDependencies.resolveDependencies(listRegisteredSprites, ix, this);
                resourcelocation = this.a(textureatlassprite);
                Object iresource = null;
                if (textureatlassprite.getIndexInMap() < 0) {
                    textureatlassprite.setIndexInMap(this.counterIndexInMap++);
                }
                if (textureatlassprite.hasCustomLoader(resourceManager, resourcelocation)) {
                    if (textureatlassprite.load(resourceManager, resourcelocation, l2 -> this.j.get(l2.toString()))) {
                        Config.dbg("Custom loader (skipped): " + textureatlassprite);
                        continue;
                    }
                    Config.dbg("Custom loader: " + textureatlassprite);
                } else {
                    cdj pngsizeinfo = cdj.a((cem)resourceManager.a(resourcelocation));
                    iresource = Config.isShaders() ? ShadersTex.loadResource(resourceManager, resourcelocation) : resourceManager.a(resourcelocation);
                    boolean flag = iresource.a("animation") != null;
                    textureatlassprite.a(pngsizeinfo, flag);
                    IOUtils.closeQuietly((Closeable)iresource);
                }
                break block38;
                catch (RuntimeException runtimeexception) {
                    h.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
                    ReflectorForge.FMLClientHandler_trackBrokenTexture(resourcelocation, runtimeexception.getMessage());
                    IOUtils.closeQuietly((Closeable)iresource);
                    continue;
                }
                catch (IOException ioexception) {
                    h.error("Using missing texture, unable to load " + resourcelocation + ", " + ioexception.getClass().getName());
                    ReflectorForge.FMLClientHandler_trackMissingTexture(resourcelocation);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(iresource);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Closeable)iresource);
                    continue;
                }
            }
            int ws = textureatlassprite.c();
            int hs = textureatlassprite.d();
            if (ws < 1 || hs < 1) {
                Config.warn("Invalid sprite size: " + textureatlassprite);
                continue;
            }
            if (ws < minSpriteSize || this.n > 0) {
                int ws2;
                int n2 = ws2 = this.n > 0 ? TextureUtils.scaleToPowerOfTwo(ws, minSpriteSize) : TextureUtils.scaleMinTo(ws, minSpriteSize);
                if (ws2 != ws) {
                    if (!TextureUtils.isPowerOfTwo(ws)) {
                        Config.log("Scaled non power of 2: " + textureatlassprite.i() + ", " + ws + " -> " + ws2);
                    } else {
                        Config.log("Scaled too small texture: " + textureatlassprite.i() + ", " + ws + " -> " + ws2);
                    }
                    int hs2 = hs * ws2 / ws;
                    textureatlassprite.b(ws2);
                    textureatlassprite.c(hs2);
                }
            }
            j2 = Math.min(j2, Math.min(textureatlassprite.c(), textureatlassprite.d()));
            int j1 = Math.min(Integer.lowestOneBit(textureatlassprite.c()), Integer.lowestOneBit(textureatlassprite.d()));
            if (j1 < k2) {
                h.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)resourcelocation, (Object)textureatlassprite.c(), (Object)textureatlassprite.d(), (Object)ri.e(k2), (Object)ri.e(j1));
                k2 = j1;
            }
            if (!this.a(resourceManager, textureatlassprite)) continue;
            stitcher.a(textureatlassprite);
        }
        int l3 = Math.min(j2, k2);
        int i1 = ri.e(l3);
        if (i1 < 0) {
            i1 = 0;
        }
        if (i1 < this.n) {
            h.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", (Object)this.l, (Object)this.n, (Object)i1, (Object)l3);
            this.n = i1;
        }
        this.o.d(this.n);
        stitcher.a(this.o);
        stitcher.c();
        h.info("Created: {}x{} {}-atlas", (Object)stitcher.a(), (Object)stitcher.b(), (Object)this.l);
        if (Config.isShaders()) {
            ShadersTex.allocateTextureMap(this.b(), this.n, stitcher.a(), stitcher.b(), stitcher, this);
        } else {
            cdr.a(this.b(), this.n, stitcher.a(), stitcher.b());
        }
        HashMap map = Maps.newHashMap(this.j);
        for (cdo textureatlassprite1 : stitcher.d()) {
            if (Config.isShaders()) {
                ShadersTex.setIconName(ShadersTex.setSprite(textureatlassprite1).i());
            }
            String s2 = textureatlassprite1.i();
            map.remove(s2);
            this.k.put(s2, textureatlassprite1);
            try {
                if (Config.isShaders()) {
                    ShadersTex.uploadTexSubForLoadAtlas(textureatlassprite1.a(0), textureatlassprite1.c(), textureatlassprite1.d(), textureatlassprite1.a(), textureatlassprite1.b(), false, false);
                } else {
                    cdr.a(textureatlassprite1.a(0), textureatlassprite1.c(), textureatlassprite1.d(), textureatlassprite1.a(), textureatlassprite1.b(), false, false);
                }
            }
            catch (Throwable throwable) {
                b crashreport = b.a(throwable, "Stitching texture atlas");
                c crashreportcategory = crashreport.a("Texture being stitched together");
                crashreportcategory.a("Atlas path", (Object)this.l);
                crashreportcategory.a("Sprite", (Object)textureatlassprite1);
                throw new f(crashreport);
            }
            if (!textureatlassprite1.m()) continue;
            this.i.add(textureatlassprite1);
        }
        for (cdo textureatlassprite2 : map.values()) {
            textureatlassprite2.a(this.o);
        }
        if (Config.isMultiTexture()) {
            int sheetWidth = stitcher.a();
            int sheetHeight = stitcher.b();
            List<cdo> listSprites = stitcher.d();
            for (cdo tas : listSprites) {
                tas.sheetWidth = sheetWidth;
                tas.sheetHeight = sheetHeight;
                tas.mipmapLevels = this.n;
                cdo ss = tas.spriteSingle;
                if (ss == null) continue;
                if (ss.c() <= 0) {
                    ss.b(tas.c());
                    ss.c(tas.d());
                    ss.a(tas.c(), tas.d(), 0, 0, false);
                    ss.l();
                    List<int[][]> frameDatas = tas.getFramesTextureData();
                    ss.a(frameDatas);
                    ss.setAnimationMetadata(tas.getAnimationMetadata());
                }
                ss.sheetWidth = sheetWidth;
                ss.sheetHeight = sheetHeight;
                ss.mipmapLevels = this.n;
                tas.bindSpriteTexture();
                boolean texBlur = false;
                boolean texClamp = true;
                try {
                    cdr.a(ss.a(0), ss.c(), ss.d(), ss.a(), ss.b(), texBlur, texClamp);
                }
                catch (Exception e2) {
                    Config.dbg("Error uploading sprite single: " + ss + ", parent: " + tas);
                    e2.printStackTrace();
                }
            }
            Config.getMinecraft().N().a(g);
        }
        Reflector.callVoid(Reflector.ForgeHooksClient_onTextureStitchedPost, this);
        this.updateIconGrid(stitcher.a(), stitcher.b());
        if (Config.equals(System.getProperty("saveTextureMap"), "true")) {
            Config.dbg("Exporting texture map: " + this.l);
            TextureUtils.saveGlTexture("debug/" + this.l.replaceAll("/", "_"), this.b(), this.n, stitcher.a(), stitcher.b());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean a(cen resourceManager, final cdo texture) {
        block11: {
            nd resourcelocation = this.a(texture);
            cem iresource = null;
            if (texture.hasCustomLoader(resourceManager, resourcelocation)) {
                TextureUtils.generateCustomMipmaps(texture, this.n);
            } else {
                boolean flag;
                try {
                    iresource = resourceManager.a(resourcelocation);
                    texture.a(iresource, this.n + 1);
                    break block11;
                }
                catch (RuntimeException runtimeexception) {
                    h.error("Unable to parse metadata from {}", (Object)resourcelocation, (Object)runtimeexception);
                    flag = false;
                }
                catch (IOException ioexception) {
                    boolean flag2;
                    h.error("Using missing texture, unable to load {}", (Object)resourcelocation, (Object)ioexception);
                    boolean bl = flag2 = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)iresource);
                }
                return flag;
            }
        }
        try {
            texture.d(this.n);
            return true;
        }
        catch (Throwable throwable) {
            b crashreport = b.a(throwable, "Applying mipmap");
            c crashreportcategory = crashreport.a("Sprite being mipmapped");
            crashreportcategory.a("Sprite name", (d)new d<String>(){

                public String a() throws Exception {
                    return texture.i();
                }
            });
            crashreportcategory.a("Sprite size", (d)new d<String>(){

                public String a() throws Exception {
                    return texture.c() + " x " + texture.d();
                }
            });
            crashreportcategory.a("Sprite frames", (d)new d<String>(){

                public String a() throws Exception {
                    return texture.k() + " frames";
                }
            });
            crashreportcategory.a("Mipmap levels", (Object)this.n);
            throw new f(crashreport);
        }
    }

    public nd a(cdo p_184396_1_) {
        nd resourcelocation = new nd(p_184396_1_.i());
        return this.completeResourceLocation(resourcelocation);
    }

    public nd completeResourceLocation(nd resourcelocation) {
        if (this.isAbsoluteLocation(resourcelocation)) {
            return new nd(resourcelocation.b(), resourcelocation.a() + ".png");
        }
        return new nd(resourcelocation.b(), String.format("%s/%s%s", this.l, resourcelocation.a(), ".png"));
    }

    public cdo a(String iconName) {
        cdo textureatlassprite = this.k.get(iconName);
        if (textureatlassprite == null) {
            textureatlassprite = this.o;
        }
        return textureatlassprite;
    }

    public void d() {
        if (Config.isShaders()) {
            ShadersTex.updatingTex = this.getMultiTexID();
        }
        boolean hasNormal = false;
        boolean hasSpecular = false;
        cdr.b(this.b());
        for (cdo textureatlassprite : this.i) {
            if (!this.isTerrainAnimationActive(textureatlassprite)) continue;
            textureatlassprite.j();
            if (textureatlassprite.spriteNormal != null) {
                hasNormal = true;
            }
            if (textureatlassprite.spriteSpecular == null) continue;
            hasSpecular = true;
        }
        if (Config.isMultiTexture()) {
            for (cdo ts : this.i) {
                cdo spriteSingle;
                if (!this.isTerrainAnimationActive(ts) || (spriteSingle = ts.spriteSingle) == null) continue;
                if (ts == TextureUtils.iconClock || ts == TextureUtils.iconCompass) {
                    spriteSingle.h = ts.h;
                }
                ts.bindSpriteTexture();
                spriteSingle.j();
            }
            cdr.b(this.b());
        }
        if (Config.isShaders()) {
            if (hasNormal) {
                cdr.b(this.getMultiTexID().norm);
                for (cdo textureatlassprite : this.i) {
                    if (textureatlassprite.spriteNormal == null || !this.isTerrainAnimationActive(textureatlassprite)) continue;
                    if (textureatlassprite == TextureUtils.iconClock || textureatlassprite == TextureUtils.iconCompass) {
                        textureatlassprite.spriteNormal.h = textureatlassprite.h;
                    }
                    textureatlassprite.spriteNormal.j();
                }
            }
            if (hasSpecular) {
                cdr.b(this.getMultiTexID().spec);
                for (cdo textureatlassprite : this.i) {
                    if (textureatlassprite.spriteSpecular == null || !this.isTerrainAnimationActive(textureatlassprite)) continue;
                    if (textureatlassprite == TextureUtils.iconClock || textureatlassprite == TextureUtils.iconCompass) {
                        textureatlassprite.spriteNormal.h = textureatlassprite.h;
                    }
                    textureatlassprite.spriteSpecular.j();
                }
            }
            if (hasNormal || hasSpecular) {
                cdr.b(this.b());
            }
        }
        if (Config.isShaders()) {
            ShadersTex.updatingTex = null;
        }
    }

    public cdo a(nd location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        cdo textureatlassprite = this.j.get(location.toString());
        if (textureatlassprite == null) {
            textureatlassprite = cdo.a(location);
            this.j.put(location.toString(), textureatlassprite);
            if (textureatlassprite.getIndexInMap() < 0) {
                textureatlassprite.setIndexInMap(this.counterIndexInMap++);
            }
        }
        return textureatlassprite;
    }

    public void e() {
        this.d();
    }

    public void a(int mipmapLevelsIn) {
        this.n = mipmapLevelsIn;
    }

    public cdo f() {
        return this.o;
    }

    @Nullable
    public cdo getTextureExtry(String name) {
        return this.j.get(name);
    }

    public boolean setTextureEntry(cdo entry) {
        String name = entry.i();
        if (!this.j.containsKey(name)) {
            this.j.put(name, entry);
            if (entry.getIndexInMap() < 0) {
                entry.setIndexInMap(this.counterIndexInMap++);
            }
            return true;
        }
        return false;
    }

    public String getBasePath() {
        return this.l;
    }

    public int getMipmapLevels() {
        return this.n;
    }

    private boolean isAbsoluteLocation(nd loc) {
        String path = loc.a();
        return this.isAbsoluteLocationPath(path);
    }

    private boolean isAbsoluteLocationPath(String resPath) {
        String path = resPath.toLowerCase();
        return path.startsWith("mcpatcher/") || path.startsWith("optifine/");
    }

    public cdo getSpriteSafe(String name) {
        nd loc = new nd(name);
        return this.j.get(loc.toString());
    }

    public cdo getRegisteredSprite(nd loc) {
        return this.j.get(loc.toString());
    }

    private boolean isTerrainAnimationActive(cdo ts) {
        if (ts == TextureUtils.iconWaterStill || ts == TextureUtils.iconWaterFlow) {
            return Config.isAnimatedWater();
        }
        if (ts == TextureUtils.iconLavaStill || ts == TextureUtils.iconLavaFlow) {
            return Config.isAnimatedLava();
        }
        if (ts == TextureUtils.iconFireLayer0 || ts == TextureUtils.iconFireLayer1) {
            return Config.isAnimatedFire();
        }
        if (ts == TextureUtils.iconPortal) {
            return Config.isAnimatedPortal();
        }
        if (ts == TextureUtils.iconClock || ts == TextureUtils.iconCompass) {
            return true;
        }
        return Config.isAnimatedTerrain();
    }

    public int getCountRegisteredSprites() {
        return this.counterIndexInMap;
    }

    private int detectMaxMipmapLevel(Map mapSprites, cen rm2) {
        int minLevel;
        int minSize = this.detectMinimumSpriteSize(mapSprites, rm2, 20);
        if (minSize < 16) {
            minSize = 16;
        }
        if ((minSize = ri.c(minSize)) > 16) {
            Config.log("Sprite size: " + minSize);
        }
        if ((minLevel = ri.e(minSize)) < 4) {
            minLevel = 4;
        }
        return minLevel;
    }

    private int detectMinimumSpriteSize(Map mapSprites, cen rm2, int percentScale) {
        HashMap<Integer, Integer> mapSizeCounts = new HashMap<Integer, Integer>();
        Set entrySetSprites = mapSprites.entrySet();
        for (Map.Entry entry : entrySetSprites) {
            cdo sprite = (cdo)entry.getValue();
            nd loc = new nd(sprite.i());
            nd locComplete = this.completeResourceLocation(loc);
            if (sprite.hasCustomLoader(rm2, loc)) continue;
            try {
                Dimension dim;
                InputStream in;
                cem res = rm2.a(locComplete);
                if (res == null || (in = res.b()) == null || (dim = TextureUtils.getImageSize(in, "png")) == null) continue;
                int width = dim.width;
                int width2 = ri.c(width);
                if (!mapSizeCounts.containsKey(width2)) {
                    mapSizeCounts.put(width2, 1);
                    continue;
                }
                int count = (Integer)mapSizeCounts.get(width2);
                mapSizeCounts.put(width2, count + 1);
            }
            catch (Exception e2) {}
        }
        int countSprites = 0;
        Set setSizes = mapSizeCounts.keySet();
        TreeSet setSizesSorted = new TreeSet(setSizes);
        Iterator it = setSizesSorted.iterator();
        while (it.hasNext()) {
            int size = (Integer)it.next();
            int count = (Integer)mapSizeCounts.get(size);
            countSprites += count;
        }
        int minSize = 16;
        int countScale = 0;
        int countScaleMax = countSprites * percentScale / 100;
        Iterator it2 = setSizesSorted.iterator();
        while (it2.hasNext()) {
            int size = (Integer)it2.next();
            int count = (Integer)mapSizeCounts.get(size);
            countScale += count;
            if (size > minSize) {
                minSize = size;
            }
            if (countScale <= countScaleMax) continue;
            return minSize;
        }
        return minSize;
    }

    private int getMinSpriteSize() {
        int minSize = 1 << this.n;
        if (minSize < 8) {
            minSize = 8;
        }
        return minSize;
    }

    private int[] getMissingImageData(int size) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        bi.setRGB(0, 0, 16, 16, cdr.b, 0, 16);
        BufferedImage bi2 = TextureUtils.scaleToPowerOfTwo(bi, size);
        int[] data = new int[size * size];
        bi2.getRGB(0, 0, size, size, data, 0, size);
        return data;
    }

    public boolean isTextureBound() {
        int texId;
        int boundTexId = buq.getBoundTexture();
        return boundTexId == (texId = this.b());
    }

    private void updateIconGrid(int sheetWidth, int sheetHeight) {
        this.iconGridCountX = -1;
        this.iconGridCountY = -1;
        this.iconGrid = null;
        if (this.iconGridSize <= 0) {
            return;
        }
        this.iconGridCountX = sheetWidth / this.iconGridSize;
        this.iconGridCountY = sheetHeight / this.iconGridSize;
        this.iconGrid = new cdo[this.iconGridCountX * this.iconGridCountY];
        this.iconGridSizeU = 1.0 / (double)this.iconGridCountX;
        this.iconGridSizeV = 1.0 / (double)this.iconGridCountY;
        for (cdo ts : this.k.values()) {
            double deltaU = 0.5 / (double)sheetWidth;
            double deltaV = 0.5 / (double)sheetHeight;
            double uMin = (double)Math.min(ts.e(), ts.f()) + deltaU;
            double vMin = (double)Math.min(ts.g(), ts.h()) + deltaV;
            double uMax = (double)Math.max(ts.e(), ts.f()) - deltaU;
            double vMax = (double)Math.max(ts.g(), ts.h()) - deltaV;
            int iuMin = (int)(uMin / this.iconGridSizeU);
            int ivMin = (int)(vMin / this.iconGridSizeV);
            int iuMax = (int)(uMax / this.iconGridSizeU);
            int ivMax = (int)(vMax / this.iconGridSizeV);
            for (int iu = iuMin; iu <= iuMax; ++iu) {
                if (iu < 0 || iu >= this.iconGridCountX) {
                    Config.warn("Invalid grid U: " + iu + ", icon: " + ts.i());
                    continue;
                }
                for (int iv = ivMin; iv <= ivMax; ++iv) {
                    if (iv < 0 || iv >= this.iconGridCountX) {
                        Config.warn("Invalid grid V: " + iv + ", icon: " + ts.i());
                        continue;
                    }
                    int index = iv * this.iconGridCountX + iu;
                    this.iconGrid[index] = ts;
                }
            }
        }
    }

    public cdo getIconByUV(double u2, double v2) {
        if (this.iconGrid == null) {
            return null;
        }
        int iv = (int)(v2 / this.iconGridSizeV);
        int iu = (int)(u2 / this.iconGridSizeU);
        int index = iv * this.iconGridCountX + iu;
        if (index < 0 || index > this.iconGrid.length) {
            return null;
        }
        return this.iconGrid[index];
    }
}

