/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Properties;

public class RandomMobsProperties {
    public String name = null;
    public String basePath = null;
    public nd[] resourceLocations = null;
    public RandomMobsRule[] rules = null;

    public RandomMobsProperties(String path, nd[] variants) {
        ConnectedParser cp = new ConnectedParser("RandomMobs");
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.resourceLocations = variants;
    }

    public RandomMobsProperties(Properties props, String path, nd baseResLoc) {
        ConnectedParser cp = new ConnectedParser("RandomMobs");
        this.name = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.rules = this.parseRules(props, baseResLoc, cp);
    }

    public nd getTextureLocation(nd loc, vo el) {
        if (this.rules != null) {
            for (int i2 = 0; i2 < this.rules.length; ++i2) {
                RandomMobsRule rule = this.rules[i2];
                if (!rule.matches(el)) continue;
                return rule.getTextureLocation(loc, el.randomMobsId);
            }
        }
        if (this.resourceLocations != null) {
            int randomId = el.randomMobsId;
            int index = randomId % this.resourceLocations.length;
            return this.resourceLocations[index];
        }
        return loc;
    }

    private RandomMobsRule[] parseRules(Properties props, nd baseResLoc, ConnectedParser cp) {
        ArrayList<RandomMobsRule> list = new ArrayList<RandomMobsRule>();
        int count = props.size();
        for (int i2 = 0; i2 < count; ++i2) {
            int index = i2 + 1;
            String valSkins = props.getProperty("skins." + index);
            if (valSkins == null) continue;
            int[] skins = cp.parseIntList(valSkins);
            int[] weights = cp.parseIntList(props.getProperty("weights." + index));
            anf[] biomes = cp.parseBiomes(props.getProperty("biomes." + index));
            RangeListInt heights = cp.parseRangeListInt(props.getProperty("heights." + index));
            if (heights == null) {
                heights = this.parseMinMaxHeight(props, index);
            }
            RandomMobsRule rule = new RandomMobsRule(baseResLoc, skins, weights, biomes, heights);
            list.add(rule);
        }
        RandomMobsRule[] rules = list.toArray(new RandomMobsRule[list.size()]);
        return rules;
    }

    private RangeListInt parseMinMaxHeight(Properties props, int index) {
        String minHeightStr = props.getProperty("minHeight." + index);
        String maxHeightStr = props.getProperty("maxHeight." + index);
        if (minHeightStr == null && maxHeightStr == null) {
            return null;
        }
        int minHeight = 0;
        if (minHeightStr != null && (minHeight = Config.parseInt(minHeightStr, -1)) < 0) {
            Config.warn("Invalid minHeight: " + minHeightStr);
            return null;
        }
        int maxHeight = 256;
        if (maxHeightStr != null && (maxHeight = Config.parseInt(maxHeightStr, -1)) < 0) {
            Config.warn("Invalid maxHeight: " + maxHeightStr);
            return null;
        }
        if (maxHeight < 0) {
            Config.warn("Invalid minHeight, maxHeight: " + minHeightStr + ", " + maxHeightStr);
            return null;
        }
        RangeListInt list = new RangeListInt();
        list.addRange(new RangeInt(minHeight, maxHeight));
        return list;
    }

    public boolean isValid(String path) {
        int i2;
        if (this.resourceLocations == null && this.rules == null) {
            Config.warn("No skins specified: " + path);
            return false;
        }
        if (this.rules != null) {
            for (i2 = 0; i2 < this.rules.length; ++i2) {
                RandomMobsRule rule = this.rules[i2];
                if (rule.isValid(path)) continue;
                return false;
            }
        }
        if (this.resourceLocations != null) {
            for (i2 = 0; i2 < this.resourceLocations.length; ++i2) {
                nd loc = this.resourceLocations[i2];
                if (Config.hasResource(loc)) continue;
                Config.warn("Texture not found: " + loc.a());
                return false;
            }
        }
        return true;
    }
}

