/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DynamicLights {
    private static Map<Integer, DynamicLight> mapDynamicLights = new HashMap<Integer, DynamicLight>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final mx<ain> PARAMETER_ITEM_STACK = new mx(6, mz.f);

    public static void entityAdded(ve entityIn, buw renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(ve entityIn, buw renderGlobal) {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            DynamicLight dynamicLight = mapDynamicLights.remove(rd.a(entityIn.S()));
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(buw renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            Collection<DynamicLight> dynamicLights = mapDynamicLights.values();
            for (DynamicLight dynamicLight : dynamicLights) {
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void updateMapDynamicLights(buw renderGlobal) {
        brz world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        List entities = world.L();
        for (ve entity : entities) {
            DynamicLight dynamicLight;
            Integer key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = rd.a(entity.S());
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = rd.a(entity.S());
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(et pos, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(pos);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(ve entity, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(entity);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(et pos) {
        double lightLevelMax = 0.0;
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            Collection<DynamicLight> dynamicLights = mapDynamicLights.values();
            for (DynamicLight dynamicLight : dynamicLights) {
                double dist;
                double light;
                double lightLevel;
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.p() - px;
                double dy = (double)pos.q() - py;
                double dz = (double)pos.r() - pz;
                double distSq = dx * dx + dy * dy + dz * dz;
                if (dynamicLight.isUnderwater() && !Config.isClearWater()) {
                    dynamicLightLevel = Config.limit(dynamicLightLevel - 2, 0, 15);
                    distSq *= 2.0;
                }
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(ain itemStack) {
        agz itemBlock;
        aou block;
        if (itemStack == null) {
            return 0;
        }
        ail item = itemStack.c();
        if (item instanceof agz && (block = (itemBlock = (agz)item).d()) != null) {
            return block.o(block.t());
        }
        if (item == aip.aB) {
            return aov.l.o(aov.l.t());
        }
        if (item == aip.bD || item == aip.bO) {
            return 10;
        }
        if (item == aip.bb) {
            return 8;
        }
        if (item == aip.cO) {
            return 8;
        }
        if (item == aip.bP) {
            return 8;
        }
        if (item == aip.ck) {
            return aov.bY.o(aov.bY.t()) / 2;
        }
        return 0;
    }

    public static int getLightLevel(ve entity) {
        acq entityCreeper;
        aeb player;
        if (entity == Config.getMinecraft().aa() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof aeb && (player = (aeb)entity).y()) {
            return 0;
        }
        if (entity.aR()) {
            return 15;
        }
        if (entity instanceof aej) {
            return 15;
        }
        if (entity instanceof ack) {
            return 15;
        }
        if (entity instanceof aco) {
            aco entityBlaze = (aco)entity;
            if (entityBlaze.p()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof adb) {
            adb emc = (adb)entity;
            if ((double)emc.b > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof acq && (double)(entityCreeper = (acq)entity).a(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof vn) {
            player = (vn)entity;
            ain stackMain = player.co();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            ain stackOff = player.cp();
            int levelOff = DynamicLights.getLightLevel(stackOff);
            ain stackHead = player.b(vj.f);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof acj) {
            acj entityItem = (acj)entity;
            ain itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(buw renderGlobal) {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            Collection<DynamicLight> lights = mapDynamicLights.values();
            Iterator<DynamicLight> it = lights.iterator();
            while (it.hasNext()) {
                DynamicLight dynamicLight = it.next();
                it.remove();
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            return mapDynamicLights.size();
        }
    }

    public static ain getItemStack(acj entityItem) {
        ain itemstack = (ain)entityItem.V().a(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

