/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class CustomSky {
    private static CustomSkyLayer[][] worldSkyLayers = null;

    public static void reset() {
        worldSkyLayers = null;
    }

    public static void update() {
        CustomSky.reset();
        if (!Config.isCustomSky()) {
            return;
        }
        worldSkyLayers = CustomSky.readCustomSkies();
    }

    private static CustomSkyLayer[][] readCustomSkies() {
        CustomSkyLayer[][] wsls = new CustomSkyLayer[10][0];
        String prefix = "mcpatcher/sky/world";
        int lastWorldId = -1;
        for (int w2 = 0; w2 < wsls.length; ++w2) {
            String worldPrefix = prefix + w2 + "/sky";
            ArrayList<CustomSkyLayer> listSkyLayers = new ArrayList<CustomSkyLayer>();
            for (int i2 = 1; i2 < 1000; ++i2) {
                String path = worldPrefix + i2 + ".properties";
                try {
                    nd locPath = new nd(path);
                    InputStream in = Config.getResourceStream(locPath);
                    if (in == null) break;
                    Properties props = new Properties();
                    props.load(in);
                    in.close();
                    Config.dbg("CustomSky properties: " + path);
                    String defSource = worldPrefix + i2 + ".png";
                    CustomSkyLayer sl = new CustomSkyLayer(props, defSource);
                    if (!sl.isValid(path)) continue;
                    nd locSource = new nd(sl.source);
                    cdq tex = TextureUtils.getTexture(locSource);
                    if (tex == null) {
                        Config.log("CustomSky: Texture not found: " + locSource);
                        continue;
                    }
                    sl.textureId = tex.b();
                    listSkyLayers.add(sl);
                    in.close();
                    continue;
                }
                catch (FileNotFoundException e2) {
                    break;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (listSkyLayers.size() <= 0) continue;
            CustomSkyLayer[] sls = listSkyLayers.toArray(new CustomSkyLayer[listSkyLayers.size()]);
            wsls[w2] = sls;
            lastWorldId = w2;
        }
        if (lastWorldId < 0) {
            return null;
        }
        int worldCount = lastWorldId + 1;
        CustomSkyLayer[][] wslsTrim = new CustomSkyLayer[worldCount][0];
        for (int i3 = 0; i3 < wslsTrim.length; ++i3) {
            wslsTrim[i3] = wsls[i3];
        }
        return wslsTrim;
    }

    public static void renderSky(ams world, cdp re2, float partialTicks) {
        if (worldSkyLayers == null) {
            return;
        }
        int dimId = world.s.q().a();
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return;
        }
        long time = world.S();
        int timeOfDay = (int)(time % 24000L);
        float celestialAngle = world.c(partialTicks);
        float rainStrength = world.j(partialTicks);
        float thunderStrength = world.h(partialTicks);
        if (rainStrength > 0.0f) {
            thunderStrength /= rainStrength;
        }
        for (int i2 = 0; i2 < sls.length; ++i2) {
            CustomSkyLayer sl = sls[i2];
            if (!sl.isActive(world, timeOfDay)) continue;
            sl.render(timeOfDay, celestialAngle, rainStrength, thunderStrength);
        }
        float rainBrightness = 1.0f - rainStrength;
        Blender.clearBlend(rainBrightness);
    }

    public static boolean hasSkyLayers(ams world) {
        if (worldSkyLayers == null) {
            return false;
        }
        if (Config.getGameSettings().e < 8) {
            return false;
        }
        int dimId = world.s.q().a();
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return false;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return false;
        }
        return sls.length > 0;
    }
}

