/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectedParser {
    private String context = null;

    public ConnectedParser(String context) {
        this.context = context;
    }

    public String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    public String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public MatchBlock[] parseMatchBlocks(String propMatchBlocks) {
        if (propMatchBlocks == null) {
            return null;
        }
        ArrayList<MatchBlock> list = new ArrayList<MatchBlock>();
        String[] blockStrs = Config.tokenize(propMatchBlocks, " ");
        for (int i2 = 0; i2 < blockStrs.length; ++i2) {
            String blockStr = blockStrs[i2];
            MatchBlock[] mbs = this.parseMatchBlock(blockStr);
            if (mbs == null) continue;
            list.addAll(Arrays.asList(mbs));
        }
        MatchBlock[] mbs = list.toArray(new MatchBlock[list.size()]);
        return mbs;
    }

    public awr parseBlockState(String str, awr def) {
        MatchBlock[] mbs = this.parseMatchBlock(str);
        if (mbs == null) {
            return def;
        }
        if (mbs.length != 1) {
            return def;
        }
        MatchBlock mb = mbs[0];
        int blockId = mb.getBlockId();
        aou block = aou.c((int)blockId);
        return block.t();
    }

    public MatchBlock[] parseMatchBlock(String blockStr) {
        if (blockStr == null) {
            return null;
        }
        if ((blockStr = blockStr.trim()).length() <= 0) {
            return null;
        }
        String[] parts = Config.tokenize(blockStr, ":");
        String domain = "minecraft";
        int blockIndex = 0;
        if (parts.length > 1 && this.isFullBlockName(parts)) {
            domain = parts[0];
            blockIndex = 1;
        } else {
            domain = "minecraft";
            blockIndex = 0;
        }
        String blockPart = parts[blockIndex];
        String[] params = Arrays.copyOfRange(parts, blockIndex + 1, parts.length);
        aou[] blocks = this.parseBlockPart(domain, blockPart);
        if (blocks == null) {
            return null;
        }
        MatchBlock[] datas = new MatchBlock[blocks.length];
        for (int i2 = 0; i2 < blocks.length; ++i2) {
            MatchBlock bd;
            aou block = blocks[i2];
            int blockId = aou.a((aou)block);
            int[] metadatas = null;
            if (params.length > 0 && (metadatas = this.parseBlockMetadatas(block, params)) == null) {
                return null;
            }
            datas[i2] = bd = new MatchBlock(blockId, metadatas);
        }
        return datas;
    }

    public boolean isFullBlockName(String[] parts) {
        if (parts.length < 2) {
            return false;
        }
        String part1 = parts[1];
        if (part1.length() < 1) {
            return false;
        }
        if (this.startsWithDigit(part1)) {
            return false;
        }
        return !part1.contains("=");
    }

    public boolean startsWithDigit(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        char ch = str.charAt(0);
        return Character.isDigit(ch);
    }

    public aou[] parseBlockPart(String domain, String blockPart) {
        if (this.startsWithDigit(blockPart)) {
            int[] ids = this.parseIntList(blockPart);
            if (ids == null) {
                return null;
            }
            aou[] blocks = new aou[ids.length];
            for (int i2 = 0; i2 < ids.length; ++i2) {
                int id = ids[i2];
                aou block = aou.c((int)id);
                if (block == null) {
                    this.warn("Block not found for id: " + id);
                    return null;
                }
                blocks[i2] = block;
            }
            return blocks;
        }
        String fullName = domain + ":" + blockPart;
        aou block = aou.b((String)fullName);
        if (block == null) {
            this.warn("Block not found for name: " + fullName);
            return null;
        }
        aou[] blocks = new aou[]{block};
        return blocks;
    }

    public int[] parseBlockMetadatas(aou block, String[] params) {
        if (params.length <= 0) {
            return null;
        }
        String param0 = params[0];
        if (this.startsWithDigit(param0)) {
            int[] mds = this.parseIntList(param0);
            return mds;
        }
        awr stateDefault = block.t();
        Collection properties = stateDefault.s();
        HashMap<axh, List<Comparable>> mapPropValues = new HashMap<axh, List<Comparable>>();
        for (int i2 = 0; i2 < params.length; ++i2) {
            String param = params[i2];
            if (param.length() <= 0) continue;
            String[] parts = Config.tokenize(param, "=");
            if (parts.length != 2) {
                this.warn("Invalid block property: " + param);
                return null;
            }
            String key = parts[0];
            String valStr = parts[1];
            axh prop = ConnectedProperties.getProperty(key, properties);
            if (prop == null) {
                this.warn("Property not found: " + key + ", block: " + block);
                return null;
            }
            ArrayList<Comparable> list = (ArrayList<Comparable>)mapPropValues.get(key);
            if (list == null) {
                list = new ArrayList<Comparable>();
                mapPropValues.put(prop, list);
            }
            String[] vals = Config.tokenize(valStr, ",");
            for (int v2 = 0; v2 < vals.length; ++v2) {
                String val = vals[v2];
                Comparable propVal = ConnectedParser.parsePropertyValue(prop, val);
                if (propVal == null) {
                    this.warn("Property value not found: " + val + ", property: " + key + ", block: " + block);
                    return null;
                }
                list.add(propVal);
            }
        }
        if (mapPropValues.isEmpty()) {
            return null;
        }
        ArrayList<Integer> listMetadatas = new ArrayList<Integer>();
        for (int i3 = 0; i3 < 16; ++i3) {
            int md = i3;
            try {
                awr bs = this.getStateFromMeta(block, md);
                if (!this.matchState(bs, mapPropValues)) continue;
                listMetadatas.add(md);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (listMetadatas.size() == 16) {
            return null;
        }
        int[] metadatas = new int[listMetadatas.size()];
        for (int i4 = 0; i4 < metadatas.length; ++i4) {
            metadatas[i4] = (Integer)listMetadatas.get(i4);
        }
        return metadatas;
    }

    private awr getStateFromMeta(aou block, int md) {
        try {
            awr bs = block.a(md);
            if (block == aov.cF && md > 7) {
                awr bsLow = block.a(md & 7);
                bs = bs.a((axh)apz.a, bsLow.c((axh)apz.a));
            }
            if (block == aov.dk && (md & 8) != 0) {
                bs = bs.a((axh)asj.a, (Comparable)Boolean.valueOf(true));
            }
            return bs;
        }
        catch (IllegalArgumentException e2) {
            return block.t();
        }
    }

    public static Comparable parsePropertyValue(axh prop, String valStr) {
        Class valueClass = prop.b();
        Comparable valueObj = ConnectedParser.parseValue(valStr, valueClass);
        if (valueObj == null) {
            Collection propertyValues = prop.c();
            valueObj = ConnectedParser.getPropertyValue(valStr, propertyValues);
        }
        return valueObj;
    }

    public static Comparable getPropertyValue(String value, Collection propertyValues) {
        for (Comparable obj : propertyValues) {
            if (!ConnectedParser.getValueName(obj).equals(value)) continue;
            return obj;
        }
        return null;
    }

    private static Object getValueName(Comparable obj) {
        if (obj instanceof rm) {
            rm iss = (rm)obj;
            return iss.m();
        }
        return obj.toString();
    }

    public static Comparable parseValue(String str, Class cls) {
        if (cls == String.class) {
            return str;
        }
        if (cls == Boolean.class) {
            return Boolean.valueOf(str);
        }
        if (cls == Float.class) {
            return Float.valueOf(str);
        }
        if (cls == Double.class) {
            return Double.valueOf(str);
        }
        if (cls == Integer.class) {
            return Integer.valueOf(str);
        }
        if (cls == Long.class) {
            return Long.valueOf(str);
        }
        return null;
    }

    public boolean matchState(awr bs, Map<axh, List<Comparable>> mapPropValues) {
        Set<axh> keys = mapPropValues.keySet();
        for (axh prop : keys) {
            List<Comparable> vals = mapPropValues.get(prop);
            Comparable bsVal = bs.c(prop);
            if (bsVal == null) {
                return false;
            }
            if (vals.contains(bsVal)) continue;
            return false;
        }
        return true;
    }

    public anf[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        boolean negative = false;
        if (str.startsWith("!")) {
            negative = true;
            str = str.substring(1);
        }
        String[] biomeNames = Config.tokenize(str, " ");
        ArrayList list = new ArrayList();
        for (int i2 = 0; i2 < biomeNames.length; ++i2) {
            String biomeName = biomeNames[i2];
            anf biome = this.findBiome(biomeName);
            if (biome == null) {
                this.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        if (negative) {
            ArrayList listAllBiomes = Lists.newArrayList((Iterator)anf.p.iterator());
            listAllBiomes.removeAll(list);
            list = listAllBiomes;
        }
        anf[] biomeArr = list.toArray(new anf[list.size()]);
        return biomeArr;
    }

    public anf findBiome(String biomeName) {
        if ((biomeName = biomeName.toLowerCase()).equals("nether")) {
            return ank.j;
        }
        Set biomeIds = anf.p.c();
        for (nd loc : biomeIds) {
            String name;
            anf biome = (anf)anf.p.c((Object)loc);
            if (biome == null || !(name = biome.l().replace(" ", "").toLowerCase()).equals(biomeName)) continue;
            return biome;
        }
        return null;
    }

    public int parseInt(String str) {
        if (str == null) {
            return -1;
        }
        int num = Config.parseInt(str = str.trim(), -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
        }
        return num;
    }

    public int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt(str = str.trim(), -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int[] parseIntList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < intStrs.length; ++i2) {
            String intStr = intStrs[i2];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize(intStr, "-");
                if (subStrs.length != 2) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min < 0 || max < 0 || min > max) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n2 = min; n2 <= max; ++n2) {
                    list.add(n2);
                }
                continue;
            }
            int val = Config.parseInt(intStr, -1);
            if (val < 0) {
                this.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i3 = 0; i3 < ints.length; ++i3) {
            ints[i3] = (Integer)list.get(i3);
        }
        return ints;
    }

    public boolean[] parseFaces(String str, boolean[] defVal) {
        if (str == null) {
            return defVal;
        }
        EnumSet<fa> setFaces = EnumSet.allOf(fa.class);
        String[] faceStrs = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < faceStrs.length; ++i2) {
            String faceStr = faceStrs[i2];
            if (faceStr.equals("sides")) {
                setFaces.add(fa.c);
                setFaces.add(fa.d);
                setFaces.add(fa.e);
                setFaces.add(fa.f);
                continue;
            }
            if (faceStr.equals("all")) {
                setFaces.addAll(Arrays.asList(fa.n));
                continue;
            }
            fa face = this.parseFace(faceStr);
            if (face == null) continue;
            setFaces.add(face);
        }
        boolean[] faces = new boolean[fa.n.length];
        for (int i3 = 0; i3 < faces.length; ++i3) {
            faces[i3] = setFaces.contains((Object)fa.n[i3]);
        }
        return faces;
    }

    public fa parseFace(String str) {
        if ((str = str.toLowerCase()).equals("bottom") || str.equals("down")) {
            return fa.a;
        }
        if (str.equals("top") || str.equals("up")) {
            return fa.b;
        }
        if (str.equals("north")) {
            return fa.c;
        }
        if (str.equals("south")) {
            return fa.d;
        }
        if (str.equals("east")) {
            return fa.f;
        }
        if (str.equals("west")) {
            return fa.e;
        }
        Config.warn("Unknown face: " + str);
        return null;
    }

    public void dbg(String str) {
        Config.dbg("" + this.context + ": " + str);
    }

    public void warn(String str) {
        Config.warn("" + this.context + ": " + str);
    }

    public RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize(str, " ,");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            RangeInt ri2 = this.parseRangeInt(part);
            if (ri2 == null) {
                return null;
            }
            list.addRange(ri2);
        }
        return list;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(45) >= 0) {
            String[] parts = Config.tokenize(str, "-");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt(parts[0], -1);
            int max = Config.parseInt(parts[1], -1);
            if (min < 0 || max < 0) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt(str, -1);
        if (val < 0) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }

    public static boolean parseBoolean(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().toLowerCase().equals("true");
    }

    public static int parseColor(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public static int parseColor4(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = (int)(Long.parseLong(str, 16) & 0xFFFFFFFFFFFFFFFFL);
            return val;
        }
        catch (NumberFormatException e2) {
            return defVal;
        }
    }

    public amk parseBlockRenderLayer(String str, amk def) {
        if (str == null) {
            return def;
        }
        str = str.toLowerCase().trim();
        amk[] layers = amk.values();
        for (int i2 = 0; i2 < layers.length; ++i2) {
            amk layer = layers[i2];
            if (!str.equals(layer.name().toLowerCase())) continue;
            return layer;
        }
        return def;
    }
}

