/*
 * Decompiled with CFR 0.152.
 */
public class CacheLocalByte {
    private int maxX = 18;
    private int maxY = 128;
    private int maxZ = 18;
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;
    private byte[][][] cache = null;
    private byte[] lastZs = null;
    private int lastDz = 0;

    public CacheLocalByte(int maxX, int maxY, int maxZ) {
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.cache = new byte[maxX][maxY][maxZ];
        this.resetCache();
    }

    public void resetCache() {
        for (int x2 = 0; x2 < this.maxX; ++x2) {
            byte[][] ys = this.cache[x2];
            for (int y = 0; y < this.maxY; ++y) {
                byte[] zs = ys[y];
                for (int z = 0; z < this.maxZ; ++z) {
                    zs[z] = -1;
                }
            }
        }
    }

    public void setOffset(int x2, int y, int z) {
        this.offsetX = x2;
        this.offsetY = y;
        this.offsetZ = z;
        this.resetCache();
    }

    public byte get(int x2, int y, int z) {
        try {
            this.lastZs = this.cache[x2 - this.offsetX][y - this.offsetY];
            this.lastDz = z - this.offsetZ;
            return this.lastZs[this.lastDz];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            return -1;
        }
    }

    public void setLast(byte val) {
        try {
            this.lastZs[this.lastDz] = val;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

