/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.minecraftExtensions;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.GameRenderHandler;
import com.shiny.joypadmod.devices.InputDevice;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McObfuscationHelper;
import com.shiny.joypadmod.inputevent.ButtonInputEvent;
import com.shiny.joypadmod.inputevent.ControllerBinding;
import com.shiny.joypadmod.minecraftExtensions.GuiSlider;
import com.shiny.joypadmod.minecraftExtensions.JoypadAdvancedMenu;
import com.shiny.joypadmod.minecraftExtensions.JoypadControlList;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;

public class JoypadConfigMenu
extends GuiScreen {
    private int currentJoyIndex = 0;
    public int controlListYStart;
    public int controlListXStart;
    public int controlListWidth;
    public int controlListHeight;
    private int labelYStart = 2;
    private int buttonYStart_top = this.labelYStart + 12;
    private int buttonYEnd_top;
    public int buttonXStart_top;
    private int sensitivityYStart;
    private int controllerStringY;
    public int controllerButtonWidth;
    private int buttonYStart_bottom;
    public int bottomButtonWidth = 70;
    public int lastKeyCode = -1;
    private GuiScreen parentScr;
    private long customBindingTickStart = 0L;
    private int customBindingKeyIndex = -1;
    private JoypadControlList optionList;
    private List<Integer> controllers;
    private int sensitivity_menuStart;
    private int sensitivity_gameStart;

    public JoypadConfigMenu(GuiScreen parent) {
        this.parentScr = parent;
        this.sensitivity_menuStart = ControllerSettings.inMenuSensitivity;
        this.sensitivity_gameStart = ControllerSettings.inGameSensitivity;
    }

    public void getControllers() {
        this.controllers = ControllerSettings.getJoypadList(ControllerSettings.getGameOption("-Global-.displayAllControls").equals("true"));
        if (!this.joyConfigMenuEnabled()) {
            this.currentJoyIndex = -1;
            return;
        }
        this.currentJoyIndex = 0;
        if (ControllerSettings.joyNo >= 0) {
            for (int i = 0; i < this.controllers.size(); ++i) {
                if (this.controllers.get(i) != ControllerSettings.joyNo) continue;
                this.currentJoyIndex = i;
                break;
            }
        }
    }

    public void func_73866_w_() {
        this.getControllers();
        this.controllerButtonWidth = this.field_146294_l - this.field_146294_l / 5;
        if (this.controllerButtonWidth > 310) {
            this.controllerButtonWidth = 310;
        }
        this.buttonXStart_top = (this.field_146294_l - this.controllerButtonWidth) / 2;
        this.buttonYStart_bottom = this.field_146295_m - 20;
        this.controllerStringY = this.buttonYStart_top;
        int buttonYOffset = 10;
        this.addButton(new GuiButton(100, this.buttonXStart_top, this.buttonYStart_top + buttonYOffset, this.controllerButtonWidth, 20, this.getJoystickInfo(JoyInfoEnum.name)), this.controllers != null && this.controllers.size() > 0);
        this.func_189646_b(new GuiButton(101, this.buttonXStart_top, this.buttonYStart_top + (buttonYOffset += 20), this.controllerButtonWidth / 2, 20, "<<"));
        this.func_189646_b(new GuiButton(102, this.buttonXStart_top + this.controllerButtonWidth / 2, this.buttonYStart_top + buttonYOffset, this.controllerButtonWidth / 2, 20, ">>"));
        this.sensitivityYStart = this.buttonYStart_top + (buttonYOffset += 22);
        GuiSlider menuSensitivity = new GuiSlider(310, this.buttonXStart_top, this.sensitivityYStart, this.controllerButtonWidth / 2, 20, "controlMenu.sensitivity.menu", (float)ControllerSettings.inMenuSensitivity / 100.0f);
        menuSensitivity.updateText();
        this.func_189646_b(menuSensitivity);
        GuiSlider guiSensitivity = new GuiSlider(320, this.buttonXStart_top + this.controllerButtonWidth / 2, this.sensitivityYStart, this.controllerButtonWidth / 2, 20, "controlMenu.sensitivity.game", (float)ControllerSettings.inGameSensitivity / 100.0f);
        guiSensitivity.updateText();
        this.func_189646_b(guiSensitivity);
        this.buttonYEnd_top = this.buttonYStart_top + (buttonYOffset += 20);
        this.controlListYStart = this.buttonYEnd_top + 2;
        this.controlListXStart = 0;
        this.controlListWidth = this.buttonXStart_top + this.controllerButtonWidth;
        this.controlListHeight = this.buttonYStart_bottom - this.buttonYEnd_top - 2;
        int rightButtonsXStart = this.controlListXStart + this.controlListWidth + 2;
        int buttonNum = 0;
        int rightButtonWidth = Math.max(this.getFontRenderer().func_78256_a(this.sGet("controlMenu.addKey")), this.getFontRenderer().func_78256_a(this.sGet("controlMenu.pressKey"))) + 10;
        int buttonYSpacing = 20;
        this.func_189646_b(new GuiButton(350, rightButtonsXStart, this.controlListYStart + buttonYSpacing * buttonNum++, rightButtonWidth, 20, this.sGet("controlMenu.addKey")));
        buttonNum = 0;
        int numBottomButtons = 4;
        int bottomButtonStart = this.buttonXStart_top + this.controllerButtonWidth / 2 - this.bottomButtonWidth / 2 * numBottomButtons;
        this.func_189646_b(new GuiButton(400, bottomButtonStart + this.bottomButtonWidth * buttonNum++, this.buttonYStart_bottom, this.bottomButtonWidth, 20, this.sGet("controls.reset")));
        this.func_189646_b(new GuiButton(500, bottomButtonStart + this.bottomButtonWidth * buttonNum++, this.buttonYStart_bottom, this.bottomButtonWidth, 20, this.sGet("gui.done")));
        this.func_189646_b(new GuiButton(420, bottomButtonStart + this.bottomButtonWidth * buttonNum++, this.buttonYStart_bottom, this.bottomButtonWidth, 20, this.sGet("controlMenu.advanced")));
        this.func_189646_b(new GuiButton(520, bottomButtonStart + this.bottomButtonWidth * buttonNum++, this.buttonYStart_bottom, this.bottomButtonWidth, 20, this.sGet("controlMenu.mouse") + " " + this.sGet("joy.menu")));
        this.optionList = new JoypadControlList(this, this.getFontRenderer());
    }

    public void func_146281_b() {
        LogHelper.Info("JoypadConfigMenu OnGuiClosed");
        if (ControllerSettings.isInputEnabled()) {
            ControllerSettings.controllerUtils.saveCurrentJoypadMap();
        }
        ControllerSettings.suspendControllerInput(false, 0L);
        if (this.sensitivity_menuStart != ControllerSettings.inMenuSensitivity || this.sensitivity_gameStart != ControllerSettings.inGameSensitivity) {
            ControllerSettings.saveSensitivityValues();
        }
        ControllerSettings.checkIfBindingsNeedUpdating();
    }

    protected void func_146284_a(GuiButton guiButton) {
        int id = this.getButtonId(guiButton);
        LogHelper.Info("Action performed on buttonID " + id);
        if (!this.joyConfigMenuEnabled() && id != 420 && id < 500) {
            return;
        }
        switch (id) {
            case 100: {
                this.toggleController();
                break;
            }
            case 101: {
                ControllerSettings.setInputEnabled(-1, false);
                this.currentJoyIndex = this.getJoypadIndex(-1);
                this.updateControllerButton();
                this.optionList.updatejoyBindKeys();
                break;
            }
            case 102: {
                ControllerSettings.setInputEnabled(-1, false);
                this.currentJoyIndex = this.getJoypadIndex(1);
                this.updateControllerButton();
                this.optionList.updatejoyBindKeys();
                break;
            }
            case 310: 
            case 320: {
                break;
            }
            case 350: {
                this.customBindingKeyIndex = ButtonsEnum.addKey.ordinal();
                this.customBindingTickStart = Minecraft.func_71386_F();
                break;
            }
            case 400: {
                if (this.currentJoyIndex == -1) break;
                ControllerSettings.resetBindings(this.getCurrentControllerId());
                break;
            }
            case 420: {
                this.field_146297_k.func_147108_a((GuiScreen)new JoypadAdvancedMenu(this, this.getCurrentControllerId()));
                break;
            }
            case 500: {
                this.field_146297_k.func_147108_a(this.parentScr);
                break;
            }
            case 520: {
                GameRenderHandler.allowOrigControlsMenu = true;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiControls((GuiScreen)this, this.field_146297_k.field_71474_y));
            }
        }
    }

    private String getJoystickInfo(JoyInfoEnum joyInfo) {
        String ret = "";
        if (!this.joyConfigMenuEnabled() || this.getCurrentControllerId() == -1) {
            return this.sGet("controlMenu.noControllers");
        }
        try {
            InputDevice control = ControllerSettings.JoypadModInputLibrary.getController(this.getCurrentControllerId());
            if (joyInfo == JoyInfoEnum.buttonAxisInfo) {
                ret = ret + String.format("%s %d/%d - ", this.sGet("controlMenu.controller"), this.currentJoyIndex + 1, this.controllers.size());
                ret = ret + String.format("%s: %d ", this.sGet("controlMenu.buttons"), control.getButtonCount());
                ret = ret + String.format("%s: %d", this.sGet("controlMenu.axis"), control.getAxisCount());
            } else if (joyInfo == JoyInfoEnum.name) {
                ret = ret + control.getName();
                if (!control.isConnected().booleanValue()) {
                    ret = ret + " [Disconnected]";
                }
                ret = ret + ": " + (ControllerSettings.isInputEnabled() ? this.sGet("options.on") : this.sGet("options.off"));
            }
        }
        catch (Exception ex) {
            ret = ret + " Exception caught getting controller info! " + ex.toString();
        }
        return ret;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        if (this.optionList != null) {
            this.optionList.drawScreen(par1, par2, par3);
        }
        this.checkCustomBindTrigger();
        this.checkSensitivitySliders();
        String titleText = String.format("Joypad Mod - %s - %s", this.sGet("controls.title"), this.sGet("controlMenu.toggleInstructions"));
        this.func_73732_a(this.getFontRenderer(), titleText, this.field_146294_l / 2, this.labelYStart, -1);
        String joyStickInfoText = this.getJoystickInfo(JoyInfoEnum.buttonAxisInfo);
        this.func_73732_a(this.getFontRenderer(), joyStickInfoText, this.field_146294_l / 2, this.controllerStringY, 0xAAAAAA);
        super.func_73863_a(par1, par2, par3);
    }

    private void checkSensitivitySliders() {
        float f = ((GuiSlider)((Object)this.field_146292_n.get(ButtonsEnum.gameSensitivity.ordinal()))).getValue();
        ControllerSettings.inGameSensitivity = (int)(f * 100.0f);
        f = ((GuiSlider)((Object)this.field_146292_n.get(ButtonsEnum.menuSensitivity.ordinal()))).getValue();
        ControllerSettings.inMenuSensitivity = (int)(f * 100.0f);
    }

    private void checkCustomBindTrigger() {
        if (this.customBindingTickStart > 0L) {
            if (Minecraft.func_71386_F() - this.customBindingTickStart > 5000L) {
                this.customBindingTickStart = 0L;
            }
            this.changeButtonText(this.customBindingKeyIndex, this.sGet("controlMenu.pressKey"));
            if (this.lastKeyCode != -1) {
                String key = Keyboard.getKeyName(this.lastKeyCode);
                this.lastKeyCode = -1;
                LogHelper.Info("Received " + key);
                this.customBindingTickStart = 0L;
                ControllerBinding binding = new ControllerBinding("user." + key, key, new ButtonInputEvent(this.getCurrentControllerId(), -1, 1.0f), new int[]{Keyboard.getKeyIndex(key)}, 0L, EnumSet.of(ControllerBinding.BindingOptions.GAME_BINDING, ControllerBinding.BindingOptions.REPEAT_IF_HELD, ControllerBinding.BindingOptions.RENDER_TICK, ControllerBinding.BindingOptions.CATEGORY_MISC));
                if (this.optionList != null && !this.optionList.joyBindKeys.contains(binding.inputString)) {
                    ControllerSettings.addUserBinding(binding);
                    this.optionList.joyBindKeys.add(binding.inputString);
                }
            }
        } else if (this.customBindingKeyIndex != -1) {
            this.changeButtonText(this.customBindingKeyIndex, this.sGet("controlMenu.addKey"));
            this.customBindingKeyIndex = -1;
        }
    }

    protected void func_73869_a(char c, int code) {
        if (this.customBindingTickStart > 0L) {
            this.lastKeyCode = code;
            return;
        }
        if (JoypadControlList.textInputName != null && JoypadControlList.textInputName.func_146176_q()) {
            this.lastKeyCode = code;
            JoypadControlList.textInputName.func_146201_a(c, code);
            return;
        }
        if (c == ' ' && this.controllers.size() > 0) {
            this.toggleController();
        } else {
            try {
                super.func_73869_a(c, code);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.optionList != null) {
            JoypadControlList.lastXClick = mouseX;
            JoypadControlList.lastYClick = mouseY;
            JoypadControlList.lastMouseButton = mouseButton;
        }
        try {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getJoypadIndex(int offset) {
        int i;
        if (offset == 0 || this.controllers.size() == 1) {
            return this.currentJoyIndex;
        }
        int n = i = offset > 0 ? this.currentJoyIndex + 1 : this.currentJoyIndex - 1;
        if (i >= this.controllers.size()) {
            i = 0;
        } else if (i < 0) {
            i = this.controllers.size() - 1;
        }
        return i;
    }

    private void changeButtonText(int buttonIndex, String text) {
        ((GuiButton)this.field_146292_n.get((int)buttonIndex)).field_146126_j = text;
    }

    private void toggleController() {
        LogHelper.Info("Enable/disable input");
        ControllerSettings.setInputEnabled(this.getCurrentControllerId(), !ControllerSettings.isInputEnabled());
        this.updateControllerButton();
    }

    private void updateControllerButton() {
        if (ControllerSettings.isInputEnabled() && ControllerSettings.joyNo != this.getCurrentControllerId()) {
            ControllerSettings.setController(this.getCurrentControllerId());
        }
        this.changeButtonText(ButtonsEnum.control.ordinal(), this.getJoystickInfo(JoyInfoEnum.name));
    }

    private void addButton(GuiButton guiButton, boolean enabled) {
        if (!enabled) {
            guiButton.field_146124_l = false;
        }
        this.field_146292_n.add(guiButton);
    }

    private int getButtonId(GuiButton guiButton) {
        return guiButton.field_146127_k;
    }

    public int getCurrentControllerId() {
        if (this.currentJoyIndex == -1) {
            return -1;
        }
        return this.controllers.get(this.currentJoyIndex);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public String sGet(String inputCode) {
        return McObfuscationHelper.lookupString(inputCode);
    }

    private boolean joyConfigMenuEnabled() {
        return this.controllers != null && this.controllers.size() > 0;
    }

    static enum JoyInfoEnum {
        name,
        buttonAxisInfo;

    }

    private static enum ButtonsEnum {
        control,
        prev,
        next,
        menuSensitivity,
        gameSensitivity,
        addKey,
        reset,
        done,
        advanced,
        mouseMenu;

    }
}

