/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.inputevent;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.inputevent.ControllerInputEvent;

public class PovInputEvent
extends ControllerInputEvent {
    int povNumber;

    public PovInputEvent(int controllerId, int povNumber, float threshold) {
        super(ControllerInputEvent.EventType.POV, controllerId, povNumber, threshold, 0.0f);
        this.povNumber = povNumber;
    }

    @Override
    protected boolean isTargetEvent() {
        if (this.povNumber == 0) {
            return ControllerSettings.JoypadModInputLibrary.isEventPovX();
        }
        return ControllerSettings.JoypadModInputLibrary.isEventPovY();
    }

    @Override
    public float getAnalogReading() {
        return (this.povNumber == 0 ? ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).getPovX() : ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).getPovY()).floatValue();
    }

    @Override
    public String getName() {
        return this.povNumber == 0 ? "POV X" : "POV Y";
    }

    public String toString() {
        return "Event: " + this.getName() + " Type: " + (Object)((Object)this.getEventType()) + " Max Value: " + this.threshold + " Current value: " + this.getAnalogReading() + " Is pressed: " + this.isPressed();
    }

    @Override
    public String getDescription() {
        return this.getName() + " " + this.getDirection(this.getThreshold());
    }

    private String getDirection(float reading) {
        if (reading == 0.0f) {
            return "";
        }
        if (reading > 0.0f) {
            return "+";
        }
        return "-";
    }

    @Override
    public boolean isValid() {
        return this.povNumber == 0 || this.povNumber == 1;
    }
}

