/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.inputevent;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.inputevent.ControllerInputEvent;

public class ButtonInputEvent
extends ControllerInputEvent {
    public ButtonInputEvent(int controllerNumber, int buttonNumber, float threshold) {
        super(ControllerInputEvent.EventType.BUTTON, controllerNumber, buttonNumber, threshold, 0.0f);
    }

    @Override
    protected boolean isTargetEvent() {
        return ControllerSettings.JoypadModInputLibrary.isEventButton() != false && ControllerSettings.JoypadModInputLibrary.getEventControlIndex() == this.buttonNumber;
    }

    @Override
    public float getAnalogReading() {
        if (ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).isButtonPressed(this.buttonNumber).booleanValue()) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public String getName() {
        if (!this.isValid()) {
            return "NONE";
        }
        return ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).getButtonName(this.buttonNumber);
    }

    public String toString() {
        return "Event: " + this.getName() + " Type: " + (Object)((Object)this.getEventType()) + " Current value: " + this.getAnalogReading() + " Is pressed: " + this.isPressed();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public boolean isValid() {
        return this.controllerNumber >= 0 && this.buttonNumber >= 0 && this.buttonNumber < ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).getButtonCount();
    }
}

