/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.inputevent;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.inputevent.ControllerInputEvent;
import com.shiny.joypadmod.inputevent.ControllerUtils;

public class AxisInputEvent
extends ControllerInputEvent {
    int axisNumber;
    boolean pressed = false;

    public AxisInputEvent(int controllerId, int axisNumber, float threshold, float deadzone) {
        super(ControllerInputEvent.EventType.AXIS, controllerId, axisNumber, threshold, deadzone);
        this.axisNumber = axisNumber;
        if (this.isValid()) {
            this.setDeadZone(deadzone);
        } else {
            if (controllerId < 0) {
                LogHelper.Error("Tried to create an axis with invalid controller number");
            } else {
                LogHelper.Error("Attempted to create a binding with invalid axis number. Axis index requested: " + axisNumber + " axis available: " + ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).getAxisCount());
            }
            LogHelper.Warn("Processing will continue with invalid axis " + axisNumber + ".  Binding will not respond until rebound and may cause instability in mod.");
        }
    }

    @Override
    protected boolean isTargetEvent() {
        return ControllerSettings.JoypadModInputLibrary.isEventAxis() != false && ControllerSettings.JoypadModInputLibrary.getEventControlIndex() == this.axisNumber;
    }

    @Override
    public float getAnalogReading() {
        if (!this.isValid()) {
            return 0.0f;
        }
        return ControllerUtils.getAxisValue(ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber), this.axisNumber);
    }

    @Override
    public float getDeadZone() {
        if (!this.isValid()) {
            return 0.0f;
        }
        return ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).getDeadZone(this.axisNumber);
    }

    @Override
    public String getName() {
        if (!this.isValid()) {
            return "Not Set";
        }
        return ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).getAxisName(this.axisNumber);
    }

    public String toString() {
        if (!this.isValid()) {
            return "Not Set";
        }
        return "Event: " + this.getName() + " Type: " + (Object)((Object)this.getEventType()) + " Threshold: " + this.threshold + " Current value: " + this.getAnalogReading() + " Is pressed: " + this.isPressed();
    }

    @Override
    public void setDeadZone(float deadzone) {
        if (!this.isValid()) {
            return;
        }
        LogHelper.Info("Setting deadzone on controller " + this.controllerNumber + " axis " + this.axisNumber + " value " + deadzone);
        ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).setDeadZone(this.axisNumber, deadzone);
        this.deadzone = deadzone;
    }

    @Override
    public String getDescription() {
        if (!this.isValid()) {
            return "NONE";
        }
        return this.getName() + " " + this.getDirection(this.getThreshold());
    }

    private String getDirection(float reading) {
        if (reading > 0.0f) {
            return "+";
        }
        return "-";
    }

    @Override
    public boolean isValid() {
        return this.controllerNumber >= 0 && this.axisNumber >= 0 && this.axisNumber < ControllerSettings.JoypadModInputLibrary.getController(this.controllerNumber).getAxisCount();
    }
}

