/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.helpers;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Customizations {
    public static void init() {
        String user = ControllerSettings.config.getDefaultCategory();
        String reticleSettings = ControllerSettings.config.getConfigFileSetting(user + ".CustomReticle");
        if (reticleSettings == "false") {
            reticleSettings = "joypadmod:textures/reticle.png,16,16,16,16";
            ControllerSettings.config.setConfigFileSetting(user + ".CustomReticle", reticleSettings);
        }
        Reticle.parseSettings(reticleSettings);
    }

    public static class Reticle {
        public static int width;
        public static int height;
        public static int imageWidth;
        public static int imageHeight;
        public static int reticleColor;
        private static String imageLocation;
        private static ResourceLocation resource;
        private static Minecraft mc;
        private static boolean glBlend;
        private static boolean glDepthTest;

        public static String getLocation() {
            return imageLocation;
        }

        public static void setLocation(String path, int inWidth, int inHeight, int inImageWidth, int inImageHeight) {
            resource = new ResourceLocation(path);
            width = inWidth;
            height = inHeight;
            imageWidth = inImageWidth;
            imageHeight = inImageHeight;
            mc = Minecraft.func_71410_x();
        }

        public static void SetupGl() {
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (GL11.glIsEnabled(2929)) {
                glDepthTest = true;
                GL11.glDisable(2929);
            }
            if (resource != null && !GL11.glIsEnabled(3042)) {
                glBlend = false;
                GL11.glEnable(3042);
            }
        }

        public static void RestoreGl() {
            if (glDepthTest) {
                GL11.glEnable(2929);
            }
            if (resource != null && !glBlend) {
                GL11.glDisable(3042);
            }
        }

        public static Boolean parseSettings(String settings) {
            String[] tokens;
            if (settings != null && (tokens = settings.split(",")).length == 5) {
                try {
                    Reticle.setLocation(tokens[0], Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4]));
                    return true;
                }
                catch (Exception ex) {
                    LogHelper.Error("Failed parsing settings string for reticle: " + settings + ". " + ex.toString());
                }
            }
            LogHelper.Error("Unexpected settings string: " + settings);
            return false;
        }

        public static void Draw(int x, int y) {
            Reticle.SetupGl();
            if (resource != null) {
                try {
                    Reticle.mc.field_71446_o.func_110577_a(resource);
                    Gui.func_146110_a((int)(x - width / 2), (int)(y - height / 2), (float)0.0f, (float)0.0f, (int)width, (int)height, (float)imageWidth, (float)imageHeight);
                }
                catch (Exception ex) {
                    LogHelper.Error("Caught exception when rendering reticle. Defaulting to basic." + ex.getMessage());
                    resource = null;
                }
            } else {
                Gui.func_73734_a((int)(x - 3), (int)y, (int)(x + 4), (int)(y + 1), (int)reticleColor);
                Gui.func_73734_a((int)x, (int)(y - 3), (int)(x + 1), (int)(y + 4), (int)reticleColor);
            }
            Reticle.RestoreGl();
        }

        static {
            reticleColor = -1;
            imageLocation = null;
            resource = null;
            glBlend = true;
            glDepthTest = false;
        }
    }
}

