/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.devices;

import com.ivan.xinput.XInputDevice;
import com.ivan.xinput.XInputDevice14;
import com.ivan.xinput.XInputLibraryVersion;
import com.ivan.xinput.enums.XInputButton;
import com.ivan.xinput.listener.SimpleXInputDeviceListener;
import com.ivan.xinput.listener.XInputDeviceListener;
import com.ivan.xinput.natives.XInputNatives;
import com.shiny.joypadmod.devices.InputDevice;
import com.shiny.joypadmod.devices.InputLibrary;
import com.shiny.joypadmod.devices.XInputDeviceWrapper;
import com.shiny.joypadmod.helpers.LogHelper;
import java.util.LinkedList;

public class XInputLibrary
extends InputLibrary {
    private Boolean created = false;
    float axisSignalThreshold = 0.5f;
    protected Boolean xInput14 = false;
    public Boolean recentlyDisconnected = false;
    public Boolean recentlyConnected = false;
    XInputDeviceWrapper theDevice;
    static LinkedList events = new LinkedList();
    int lastEvent = -1;
    int lastEventControlIndex = -1;
    XInputDeviceListener listener = new SimpleXInputDeviceListener(){

        @Override
        public void connected() {
            LogHelper.Info("Connection message received");
            XInputLibrary.this.recentlyConnected = true;
        }

        @Override
        public void disconnected() {
            LogHelper.Info("Disconnection message received");
            XInputLibrary.this.recentlyDisconnected = true;
        }

        @Override
        public void buttonChanged(XInputButton button, boolean pressed) {
            events.add(new InputEvent(0, button.ordinal()));
            LogHelper.Info(button.name() + (pressed ? " pressed" : " released"));
        }
    };

    @Override
    public void create() throws Exception {
        if (XInputDevice14.isAvailable()) {
            this.xInput14 = true;
        } else if (!XInputDevice.isAvailable()) {
            if (!XInputNatives.isLoaded()) {
                LogHelper.Error("XInput native libraries failed to load with error: " + XInputNatives.getLoadError().toString());
            } else {
                LogHelper.Error("XInputNatives were loaded but XInputDevice reports it is not available");
            }
            throw new Exception("XInput is not available on system.");
        }
        this.theDevice = new XInputDeviceWrapper(0);
        this.theDevice.setIndex(0, this.xInput14);
        this.created = true;
        LogHelper.Info("XInput is available on system.  Using version: " + XInputLibraryVersion.values()[XInputNatives.getLoadedLibVersion()].toString());
    }

    @Override
    public Boolean isCreated() {
        return this.created;
    }

    @Override
    public void clearEvents() {
        events.clear();
    }

    @Override
    public InputDevice getController(int index) {
        if (index != this.theDevice.theDevice.getPlayerNum()) {
            this.theDevice.theDevice.removeListener(this.listener);
            this.theDevice.setIndex(index, this.xInput14);
            this.theDevice.theDevice.addListener(this.listener);
        }
        return this.theDevice;
    }

    @Override
    public int getControllerCount() {
        return 4;
    }

    @Override
    public InputDevice getEventSource() {
        return this.theDevice;
    }

    @Override
    public int getEventControlIndex() {
        return this.lastEventControlIndex;
    }

    @Override
    public Boolean isEventButton() {
        return this.lastEvent == 0;
    }

    @Override
    public Boolean isEventAxis() {
        return this.lastEvent == 1;
    }

    @Override
    public Boolean isEventPovX() {
        return false;
    }

    @Override
    public Boolean isEventPovY() {
        return false;
    }

    @Override
    public Boolean next() {
        if (events.isEmpty()) {
            return false;
        }
        InputEvent event = (InputEvent)events.removeFirst();
        this.lastEvent = event.eventType;
        this.lastEventControlIndex = event.eventControlIndex;
        return true;
    }

    @Override
    public void poll() {
        this.theDevice.theDevice.poll();
        for (int i = 0; i < 6; ++i) {
            if (!(Math.abs(this.theDevice.getAxisValue(i)) > this.axisSignalThreshold)) continue;
            events.add(new InputEvent(1, i));
        }
    }

    @Override
    public Boolean wasDisconnected() {
        if (this.recentlyDisconnected.booleanValue()) {
            this.recentlyDisconnected = false;
            return true;
        }
        return false;
    }

    @Override
    public Boolean wasConnected() {
        if (this.recentlyConnected.booleanValue()) {
            this.recentlyConnected = false;
            return true;
        }
        return false;
    }

    @Override
    public InputDevice getCurrentController() {
        return this.theDevice;
    }

    public class InputEvent {
        int eventType = -1;
        int eventControlIndex = -1;

        public InputEvent(int event, int controlIndex) {
            this.eventType = event;
            this.eventControlIndex = controlIndex;
        }
    }
}

