/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod.devices;

import com.ivan.xinput.XInputBatteryInformation;
import com.ivan.xinput.XInputButtons;
import com.ivan.xinput.XInputDevice;
import com.ivan.xinput.XInputDevice14;
import com.ivan.xinput.enums.XInputAxis;
import com.ivan.xinput.enums.XInputBatteryDeviceType;
import com.ivan.xinput.enums.XInputButton;
import com.ivan.xinput.exceptions.XInputNotLoadedException;
import com.shiny.joypadmod.devices.InputDevice;
import com.shiny.joypadmod.helpers.LogHelper;

public class XInputDeviceWrapper
extends InputDevice {
    public XInputDevice theDevice;
    public Boolean xInput14 = false;
    float[] deadZones = new float[]{0.15f, 0.15f, 0.15f, 0.15f, 0.15f, 0.15f};

    public XInputDeviceWrapper(int index) {
        super(index);
    }

    @Override
    public String getName() {
        String name = "XInput Device";
        return name;
    }

    @Override
    public int getButtonCount() {
        return 15;
    }

    @Override
    public int getAxisCount() {
        return 6;
    }

    @Override
    public float getAxisValue(int axisIndex) {
        float value = this.theDevice.getComponents().getAxes().get(XInputAxis.values()[axisIndex]);
        if (Math.abs(value) > this.deadZones[axisIndex]) {
            XInputAxis axis = XInputAxis.values()[axisIndex];
            if (axis == XInputAxis.LEFT_THUMBSTICK_Y || axis == XInputAxis.RIGHT_THUMBSTICK_Y) {
                value *= -1.0f;
            }
            return value;
        }
        return 0.0f;
    }

    @Override
    public String getAxisName(int index) {
        String name = XInputAxis.values()[index].toString();
        String ret = name.length() > 11 ? String.format("%s %s", name.substring(0, 9), Character.valueOf(name.charAt(name.length() - 1))) : name;
        return ret;
    }

    @Override
    public float getDeadZone(int index) {
        return this.deadZones[index];
    }

    @Override
    public String getButtonName(int index) {
        return XInputButton.values()[index].toString();
    }

    @Override
    public Boolean isButtonPressed(int index) {
        return this.isPressed(XInputButton.values()[index], this.theDevice.getComponents().getButtons());
    }

    @Override
    public Float getPovX() {
        if (this.theDevice.getDelta().getButtons().isPressed(XInputButton.DPAD_LEFT)) {
            return Float.valueOf(-1.0f);
        }
        if (this.theDevice.getDelta().getButtons().isPressed(XInputButton.DPAD_RIGHT)) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public Float getPovY() {
        if (this.theDevice.getDelta().getButtons().isPressed(XInputButton.DPAD_UP)) {
            return Float.valueOf(1.0f);
        }
        if (this.theDevice.getDelta().getButtons().isPressed(XInputButton.DPAD_DOWN)) {
            return Float.valueOf(-1.0f);
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public void setDeadZone(int axisIndex, float value) {
        this.deadZones[axisIndex] = value;
    }

    protected void setIndex(int index, Boolean useXInput14) {
        try {
            if (useXInput14.booleanValue()) {
                this.xInput14 = true;
                this.theDevice = XInputDevice14.getDeviceFor(index);
            } else {
                this.theDevice = XInputDevice.getDeviceFor(index);
            }
            this.myIndex = index;
            this.theDevice.poll();
        }
        catch (XInputNotLoadedException e) {
            LogHelper.Fatal("Failed calling setIndex on XInputDevice: " + e.toString());
        }
    }

    @Override
    public Boolean isConnected() {
        return this.theDevice.isConnected();
    }

    @Override
    public int getBatteryLevel() {
        try {
            XInputBatteryInformation gamepadBattInfo = ((XInputDevice14)this.theDevice).getBatteryInformation(XInputBatteryDeviceType.GAMEPAD);
            return gamepadBattInfo.getLevel().ordinal();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public Boolean isPressed(XInputButton buttonToCheck, XInputButtons buttons) {
        switch (buttonToCheck) {
            case A: {
                return buttons.a;
            }
            case B: {
                return buttons.b;
            }
            case X: {
                return buttons.x;
            }
            case Y: {
                return buttons.y;
            }
            case BACK: {
                return buttons.back;
            }
            case START: {
                return buttons.start;
            }
            case LEFT_SHOULDER: {
                return buttons.lShoulder;
            }
            case RIGHT_SHOULDER: {
                return buttons.rShoulder;
            }
            case LEFT_THUMBSTICK: {
                return buttons.lThumb;
            }
            case RIGHT_THUMBSTICK: {
                return buttons.rThumb;
            }
            case DPAD_UP: {
                return buttons.up;
            }
            case DPAD_DOWN: {
                return buttons.down;
            }
            case DPAD_LEFT: {
                return buttons.left;
            }
            case DPAD_RIGHT: {
                return buttons.right;
            }
            case GUIDE_BUTTON: {
                return buttons.guide;
            }
        }
        return false;
    }
}

