/*
 * Decompiled with CFR 0.152.
 */
package com.shiny.joypadmod;

import com.shiny.joypadmod.ControllerSettings;
import com.shiny.joypadmod.helpers.LogHelper;
import com.shiny.joypadmod.helpers.McGuiHelper;
import com.shiny.joypadmod.helpers.ModVersionHelper;
import com.shiny.joypadmod.lwjglVirtualInput.VirtualKeyboard;
import com.shiny.joypadmod.lwjglVirtualInput.VirtualMouse;
import com.shiny.joypadmod.minecraftExtensions.JoypadMouseHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MouseHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="joypadsplitscreenmod", name="Joypad / SplitScreen Mod", version="1.12.0-0.22", clientSideOnly=true, acceptedMinecraftVersions="[1.12,)")
public class JoypadMod {
    public static final String MODID = "joypadsplitscreenmod";
    public static final String NAME = "Joypad / SplitScreen Mod";
    public static final float MINVERSION = 0.22f;
    public static final String REVISION = "";
    private static ControllerSettings controllerSettings;
    private ModVersionHelper modHelper;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHelper.Info("preInit");
        controllerSettings = new ControllerSettings(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LogHelper.Info("init");
        try {
            if (!(Minecraft.func_71410_x().field_71417_B instanceof MouseHelper)) {
                LogHelper.Warn("Replacing Mousehelper that may have already been replaced by another mod!");
            }
            Minecraft.func_71410_x().field_71417_B = new JoypadMouseHelper();
            LogHelper.Info("Replaced mousehelper in Minecraft with JoypadMouseHelper");
        }
        catch (Exception ex) {
            LogHelper.Warn("Unable to exchange mousehelper. Game may grab mouse from keyboard players!");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LogHelper.Info("postInit");
        controllerSettings.init();
        try {
            VirtualKeyboard.create();
        }
        catch (Exception ex) {
            LogHelper.Fatal("Unable to initialize VirtualKeyboard.  Limited compatibility with some mods likely. " + ex.toString());
        }
        try {
            VirtualMouse.create();
        }
        catch (Exception ex) {
            LogHelper.Fatal("Unable to initialize VirtualMouse.  Unable to continue. " + ex.toString());
            ControllerSettings.modDisabled = true;
        }
        try {
            McGuiHelper.create();
        }
        catch (Exception ex) {
            LogHelper.Fatal("Unable to initialize McGuiHelper.  Unable to continue. " + ex.toString());
            ControllerSettings.modDisabled = true;
        }
        this.modHelper = new ModVersionHelper();
        this.modHelper.gameInit();
    }
}

