/*
 * Decompiled with CFR 0.152.
 */
package com.ivan.xinput.natives;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class NativeLibraryHelper {
    private static final boolean DEBUG = Boolean.getBoolean("native.debug");
    private static final String DEBUG_SUFFIX = System.getProperty("native.debug.suffix", "-d");
    private static final SystemArch ARCHITECTURE = System.getProperty("os.arch").contains("64") ? SystemArch.x64 : SystemArch.x86;
    private static final OS OPERATING_SYSTEM;
    private static final File LIB_DIR;

    private NativeLibraryHelper() {
    }

    public static void load(String path, String libName) throws IOException {
        NativeLibraryHelper.load(path, libName, ClassLoader.getSystemClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String path, String libName, ClassLoader cl) throws IOException {
        File outputFile;
        String baseName = libName + (DEBUG ? DEBUG_SUFFIX : "");
        String filename = OPERATING_SYSTEM.toFilename(baseName);
        String resourcePath = path + "/" + OPERATING_SYSTEM.getName() + "-" + (Object)((Object)ARCHITECTURE) + "/" + filename;
        InputStream input = cl.getResourceAsStream(resourcePath);
        if (input == null) {
            throw new IOException("Library " + libName + " not found. Full path: " + resourcePath);
        }
        try {
            outputFile = new File(LIB_DIR, filename);
            if (outputFile.exists()) {
                String md5sumFile;
                String md5sumJar = NativeLibraryHelper.md5sum(cl.getResourceAsStream(resourcePath));
                if (md5sumJar.equals(md5sumFile = NativeLibraryHelper.md5sum(new FileInputStream(outputFile)))) {
                    System.load(outputFile.getAbsolutePath());
                    return;
                }
            } else {
                outputFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(outputFile);
            try {
                int len;
                byte[] buf = new byte[65536];
                while ((len = input.read(buf)) > -1) {
                    fos.write(buf, 0, len);
                }
            }
            finally {
                fos.close();
            }
        }
        finally {
            input.close();
        }
        System.load(outputFile.getAbsolutePath());
    }

    private static String md5sum(InputStream input) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(in, digest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream md5out = new ByteArrayOutputStream();
            md5out.write(digest.digest());
            String string = md5out.toString();
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("MD5 algorithm is not available", e);
        }
        finally {
            in.close();
        }
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        OPERATING_SYSTEM = osName.contains("windows") ? OS.WINDOWS : (osName.contains("nux") ? OS.LINUX : (osName.contains("nix") || osName.contains("aix") ? OS.UNIX_LIKE : (osName.contains("mac") ? OS.MAC_OS : OS.OTHER)));
        String nativeLibPath = System.getProperty("native.lib.path", System.getProperty("java.io.tmpdir") + File.separator + "nativelibs");
        LIB_DIR = new File(nativeLibPath, ARCHITECTURE.toString());
        LIB_DIR.mkdirs();
        String pathSep = File.pathSeparator;
        System.setProperty("java.library.path", System.getProperty("java.library.path") + pathSep + LIB_DIR.getAbsolutePath());
        try {
            Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
            sysPathsField.setAccessible(true);
            sysPathsField.set(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static enum OS {
        WINDOWS("win", "", ".dll"),
        LINUX("linux", "lib", ".so"),
        UNIX_LIKE("unix", "lib", ".so"),
        MAC_OS("mac", "lib", ".dylib"),
        OTHER("other", "", "");

        private final String name;
        private final String libPrefix;
        private final String libExt;

        private OS(String name, String libPrefix, String libExt) {
            this.name = name;
            this.libPrefix = libPrefix;
            this.libExt = libExt;
        }

        public String getName() {
            return this.name;
        }

        public String toFilename(String libName) {
            return this.libPrefix + libName + this.libExt;
        }
    }

    private static enum SystemArch {
        x86,
        x64;

    }
}

