/*
 * Decompiled with CFR 0.152.
 */
package com.ivan.xinput;

import java.nio.ByteBuffer;

public class XInputKeystroke {
    private final short virtualKey;
    private final char unicode;
    private final boolean keyDown;
    private final boolean keyUp;
    private final boolean repeat;
    private final byte userIndex;
    private final byte hidCode;

    XInputKeystroke(ByteBuffer buffer) {
        this.virtualKey = buffer.getShort();
        this.unicode = buffer.getChar();
        short flags = buffer.getShort();
        this.keyDown = (flags & 1) != 0;
        this.keyUp = (flags & 2) != 0;
        this.repeat = (flags & 4) != 0;
        this.userIndex = buffer.get();
        this.hidCode = buffer.get();
    }

    public short getVirtualKey() {
        return this.virtualKey;
    }

    public char getUnicode() {
        return this.unicode;
    }

    public boolean isKeyDown() {
        return this.keyDown;
    }

    public boolean isKeyUp() {
        return this.keyUp;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public byte getUserIndex() {
        return this.userIndex;
    }

    public byte getHidCode() {
        return this.hidCode;
    }
}

