/*
 * Decompiled with CFR 0.152.
 */
package com.ivan.xinput;

import com.ivan.xinput.XInputBatteryInformation;
import com.ivan.xinput.XInputCapabilities;
import com.ivan.xinput.XInputDevice;
import com.ivan.xinput.XInputKeystroke;
import com.ivan.xinput.enums.XInputBatteryDeviceType;
import com.ivan.xinput.exceptions.XInputNotLoadedException;
import com.ivan.xinput.natives.XInputNatives14;
import java.nio.ByteBuffer;

public class XInputDevice14
extends XInputDevice {
    private final ByteBuffer capsBuffer = XInputDevice14.newBuffer(20);
    private final ByteBuffer battBuffer = XInputDevice14.newBuffer(2);
    private final ByteBuffer keysBuffer = XInputDevice14.newBuffer(8);
    private static final XInputDevice14[] DEVICES;

    protected XInputDevice14(int playerNum) {
        super(playerNum);
    }

    public static boolean isAvailable() {
        return DEVICES != null;
    }

    public static XInputDevice14[] getAllDevices() throws XInputNotLoadedException {
        XInputDevice14.checkLibraryReady();
        return (XInputDevice14[])DEVICES.clone();
    }

    public static XInputDevice14 getDeviceFor(int playerNum) throws XInputNotLoadedException {
        XInputDevice14.checkLibraryReady();
        if (playerNum < 0 || playerNum >= 4) {
            throw new IllegalArgumentException("Invalid player number: " + playerNum + ". Must be between 0 and " + 3);
        }
        return DEVICES[playerNum];
    }

    public static void setEnabled(boolean enabled) {
        XInputNatives14.setEnabled(enabled);
    }

    public XInputCapabilities getCapabilities() {
        return this.getCapabilities(0);
    }

    public XInputCapabilities getGamepadCapabilities() {
        return this.getCapabilities(1);
    }

    private XInputCapabilities getCapabilities(int flags) {
        if (!this.checkReturnCode(XInputNatives14.getCapabilities(this.playerNum, flags, this.capsBuffer))) {
            return null;
        }
        XInputCapabilities caps = new XInputCapabilities(this.capsBuffer);
        this.capsBuffer.flip();
        return caps;
    }

    public XInputBatteryInformation getBatteryInformation(XInputBatteryDeviceType deviceType) {
        if (!this.checkReturnCode(XInputNatives14.getBatteryInformation(this.playerNum, 0, this.battBuffer))) {
            return null;
        }
        XInputBatteryInformation battInfo = new XInputBatteryInformation(this.battBuffer);
        this.battBuffer.flip();
        return battInfo;
    }

    public XInputKeystroke getKeystroke() {
        int ret = XInputNatives14.getKeystroke(this.playerNum, this.keysBuffer);
        if (!this.checkReturnCode(ret, 4306) && ret == 4306) {
            return null;
        }
        XInputKeystroke keystroke = new XInputKeystroke(this.keysBuffer);
        this.keysBuffer.flip();
        return keystroke;
    }

    private static void checkLibraryReady() throws XInputNotLoadedException {
        if (!XInputNatives14.isLoaded()) {
            throw new XInputNotLoadedException("Native library failed to load", XInputNatives14.getLoadError());
        }
    }

    static {
        XInputDevice14[] devices;
        if (XInputNatives14.isLoaded()) {
            devices = new XInputDevice14[4];
            for (int i = 0; i < 4; ++i) {
                devices[i] = new XInputDevice14(i);
            }
        } else {
            devices = null;
        }
        DEVICES = devices;
    }
}

