/*
 * Decompiled with CFR 0.152.
 */
package com.ivan.xinput;

import com.ivan.xinput.XInputAxes;
import com.ivan.xinput.XInputButtons;
import com.ivan.xinput.XInputButtonsDelta;
import com.ivan.xinput.XInputComponents;
import com.ivan.xinput.XInputComponentsDelta;
import com.ivan.xinput.XInputLibraryVersion;
import com.ivan.xinput.enums.XInputButton;
import com.ivan.xinput.exceptions.XInputNotLoadedException;
import com.ivan.xinput.listener.XInputDeviceListener;
import com.ivan.xinput.natives.XInputNatives;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;

public class XInputDevice {
    protected final int playerNum;
    private final ByteBuffer buffer;
    private final XInputComponents lastComponents;
    private final XInputComponents components;
    private final XInputComponentsDelta delta;
    private boolean connected;
    private final List<XInputDeviceListener> listeners;
    private static final XInputDevice[] DEVICES;
    private static final XInputLibraryVersion LIBRARY_VERSION;
    private static final boolean GUIDE_BUTTON_SUPPORTED;
    private static XInputStateReader stateReader;

    protected XInputDevice(int playerNum) {
        this.playerNum = playerNum;
        this.buffer = XInputDevice.newBuffer(16);
        this.lastComponents = new XInputComponents();
        this.components = new XInputComponents();
        this.delta = new XInputComponentsDelta(this.lastComponents, this.components);
        this.listeners = new LinkedList<XInputDeviceListener>();
        this.poll();
    }

    public static boolean isAvailable() {
        return DEVICES != null;
    }

    public static XInputLibraryVersion getLibraryVersion() {
        return LIBRARY_VERSION;
    }

    public static boolean isGuideButtonSupported() {
        return GUIDE_BUTTON_SUPPORTED;
    }

    public static XInputDevice[] getAllDevices() throws XInputNotLoadedException {
        XInputDevice.checkLibraryReady();
        return (XInputDevice[])DEVICES.clone();
    }

    public static XInputDevice getDeviceFor(int playerNum) throws XInputNotLoadedException {
        XInputDevice.checkLibraryReady();
        if (playerNum < 0 || playerNum >= 4) {
            throw new IllegalArgumentException("Invalid player number: " + playerNum + ". Must be between 0 and " + 3);
        }
        return DEVICES[playerNum];
    }

    public static void setPreProcessData(boolean preprocess) {
        stateReader = preprocess ? XInputStatePreProcessedReader.INSTANCE : XInputStateRawReader.INSTANCE;
    }

    public void addListener(XInputDeviceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(XInputDeviceListener listener) {
        this.listeners.remove(listener);
    }

    public boolean poll() {
        if (!this.checkReturnCode(XInputNatives.pollDevice(this.playerNum, this.buffer))) {
            return false;
        }
        this.setConnected(true);
        this.lastComponents.copy(this.components);
        stateReader.read(this.buffer, this.components);
        this.processDelta();
        return true;
    }

    protected boolean checkReturnCode(int ret) {
        if (ret == 1167) {
            this.setConnected(false);
            return false;
        }
        if (ret != 0) {
            this.setConnected(false);
            throw new IllegalStateException("Could not read controller state: 0x" + Integer.toHexString(ret));
        }
        return true;
    }

    protected boolean checkReturnCode(int ret, int ... validRetCodes) {
        if (ret == 1167) {
            this.setConnected(false);
            return false;
        }
        if (ret != 0) {
            this.setConnected(false);
            for (int validRet : validRetCodes) {
                if (ret != validRet) continue;
                return false;
            }
            throw new IllegalStateException("Could not read controller state: 0x" + Integer.toHexString(ret));
        }
        return true;
    }

    private void setConnected(boolean state) {
        boolean lastConnected = this.connected;
        this.connected = state;
        for (XInputDeviceListener listener : this.listeners) {
            if (this.connected && !lastConnected) {
                listener.connected();
                continue;
            }
            if (this.connected || !lastConnected) continue;
            listener.disconnected();
        }
    }

    private void processDelta() {
        XInputButtonsDelta buttons = this.delta.getButtons();
        for (XInputDeviceListener listener : this.listeners) {
            for (XInputButton button : XInputButton.values()) {
                if (buttons.isPressed(button)) {
                    listener.buttonChanged(button, true);
                    continue;
                }
                if (!buttons.isReleased(button)) continue;
                listener.buttonChanged(button, false);
            }
        }
    }

    public boolean setVibration(int leftMotor, int rightMotor) {
        if (leftMotor < 0 || leftMotor > 65535) {
            throw new IllegalArgumentException("Left motor speed out of range (0..65535): " + leftMotor);
        }
        if (rightMotor < 0 || rightMotor > 65535) {
            throw new IllegalArgumentException("Right motor speed out of range (0..65535): " + rightMotor);
        }
        return XInputNatives.setVibration(this.playerNum, leftMotor, rightMotor) == 0;
    }

    public XInputComponents getLastComponents() {
        return this.lastComponents;
    }

    public XInputComponents getComponents() {
        return this.components;
    }

    public XInputComponentsDelta getDelta() {
        return this.delta;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getPlayerNum() {
        return this.playerNum;
    }

    private static void checkLibraryReady() throws XInputNotLoadedException {
        if (!XInputNatives.isLoaded()) {
            throw new XInputNotLoadedException("Native library failed to load", XInputNatives.getLoadError());
        }
    }

    protected static ByteBuffer newBuffer(int capacity) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    static {
        XInputDevice[] devices;
        stateReader = XInputStatePreProcessedReader.INSTANCE;
        if (XInputNatives.isLoaded()) {
            devices = new XInputDevice[4];
            for (int i = 0; i < 4; ++i) {
                devices[i] = new XInputDevice(i);
            }
        } else {
            devices = null;
        }
        DEVICES = devices;
        LIBRARY_VERSION = XInputLibraryVersion.values()[XInputNatives.getLoadedLibVersion()];
        GUIDE_BUTTON_SUPPORTED = XInputNatives.isGuideButtonSupported();
    }

    private static class XInputStatePreProcessedReader
    extends XInputStateRawReader {
        public static final XInputStatePreProcessedReader INSTANCE = new XInputStatePreProcessedReader();

        protected XInputStatePreProcessedReader() {
        }

        @Override
        public void read(ByteBuffer buffer, XInputComponents components) {
            super.read(buffer, components);
            XInputAxes axes = components.getAxes();
            axes.lx = (float)(axes.lxRaw + 32768) / 32767.5f - 1.0f;
            axes.ly = (float)(axes.lyRaw + 32768) / 32767.5f - 1.0f;
            axes.rx = (float)(axes.rxRaw + 32768) / 32767.5f - 1.0f;
            axes.ry = (float)(axes.ryRaw + 32768) / 32767.5f - 1.0f;
            axes.lt = (float)(axes.ltRaw & 0xFF) / 255.0f;
            axes.rt = (float)(axes.rtRaw & 0xFF) / 255.0f;
        }
    }

    private static class XInputStateRawReader
    implements XInputStateReader {
        public static final XInputStateRawReader INSTANCE = new XInputStateRawReader();

        protected XInputStateRawReader() {
        }

        @Override
        public void read(ByteBuffer buffer, XInputComponents components) {
            buffer.getInt();
            short btns = buffer.getShort();
            byte leftTrigger = buffer.get();
            byte rightTrigger = buffer.get();
            short thumbLX = buffer.getShort();
            short thumbLY = buffer.getShort();
            short thumbRX = buffer.getShort();
            short thumbRY = buffer.getShort();
            buffer.flip();
            boolean up = (btns & 1) != 0;
            boolean down = (btns & 2) != 0;
            boolean left = (btns & 4) != 0;
            boolean right = (btns & 8) != 0;
            XInputAxes axes = components.getAxes();
            axes.lxRaw = thumbLX;
            axes.lyRaw = thumbLY;
            axes.rxRaw = thumbRX;
            axes.ryRaw = thumbRY;
            axes.ltRaw = leftTrigger & 0xFF;
            axes.rtRaw = rightTrigger & 0xFF;
            axes.ly = 0.0f;
            axes.lx = 0.0f;
            axes.ry = 0.0f;
            axes.rx = 0.0f;
            axes.rt = 0.0f;
            axes.lt = 0.0f;
            axes.dpad = XInputAxes.dpadFromButtons(up, down, left, right);
            XInputButtons buttons = components.getButtons();
            buttons.a = (btns & 0x1000) != 0;
            buttons.b = (btns & 0x2000) != 0;
            buttons.x = (btns & 0x4000) != 0;
            buttons.y = (btns & Short.MIN_VALUE) != 0;
            buttons.back = (btns & 0x20) != 0;
            buttons.start = (btns & 0x10) != 0;
            buttons.lShoulder = (btns & 0x100) != 0;
            buttons.rShoulder = (btns & 0x200) != 0;
            buttons.lThumb = (btns & 0x40) != 0;
            buttons.rThumb = (btns & 0x80) != 0;
            buttons.guide = (btns & 0x400) != 0;
            buttons.unknown = (btns & 0x800) != 0;
            buttons.up = up;
            buttons.down = down;
            buttons.left = left;
            buttons.right = right;
        }
    }

    private static interface XInputStateReader {
        public void read(ByteBuffer var1, XInputComponents var2);
    }
}

