/*
 * Decompiled with CFR 0.152.
 */
package com.ivan.xinput;

import com.ivan.xinput.XInputCapsResolutions;
import com.ivan.xinput.enums.XInputButton;
import com.ivan.xinput.enums.XInputDeviceSubType;
import com.ivan.xinput.enums.XInputDeviceType;
import com.ivan.xinput.natives.XInputNatives;
import java.nio.ByteBuffer;
import java.util.EnumSet;

public class XInputCapabilities {
    private final XInputDeviceType type;
    private final XInputDeviceSubType subType;
    private final boolean forceFeedbackSupported;
    private final boolean wireless;
    private final boolean voiceSupported;
    private final boolean pluginModulesSupported;
    private final boolean noNavigation;
    private final EnumSet<XInputButton> supportedButtons = EnumSet.noneOf(XInputButton.class);
    private final XInputCapsResolutions resolutions;

    XInputCapabilities(ByteBuffer buffer) {
        byte type = buffer.get();
        byte subType = buffer.get();
        this.type = XInputDeviceType.fromNative(type);
        this.subType = XInputDeviceSubType.fromNative(subType);
        short flags = buffer.getShort();
        this.forceFeedbackSupported = (flags & 1) != 0;
        this.wireless = (flags & 2) != 0;
        this.voiceSupported = (flags & 4) != 0;
        this.pluginModulesSupported = (flags & 8) != 0;
        this.noNavigation = (flags & 0x10) != 0;
        short buttons = buffer.getShort();
        this.addSupportedButton(buttons, (short)4096, XInputButton.A);
        this.addSupportedButton(buttons, (short)8192, XInputButton.B);
        this.addSupportedButton(buttons, (short)16384, XInputButton.X);
        this.addSupportedButton(buttons, (short)Short.MIN_VALUE, XInputButton.Y);
        this.addSupportedButton(buttons, (short)32, XInputButton.BACK);
        this.addSupportedButton(buttons, (short)16, XInputButton.START);
        this.addSupportedButton(buttons, (short)256, XInputButton.LEFT_SHOULDER);
        this.addSupportedButton(buttons, (short)512, XInputButton.RIGHT_SHOULDER);
        this.addSupportedButton(buttons, (short)64, XInputButton.LEFT_THUMBSTICK);
        this.addSupportedButton(buttons, (short)128, XInputButton.RIGHT_THUMBSTICK);
        this.addSupportedButton(buttons, (short)1024, XInputButton.GUIDE_BUTTON);
        this.addSupportedButton(buttons, (short)2048, XInputButton.UNKNOWN);
        this.addSupportedButton(buttons, (short)1, XInputButton.DPAD_UP);
        this.addSupportedButton(buttons, (short)2, XInputButton.DPAD_DOWN);
        this.addSupportedButton(buttons, (short)4, XInputButton.DPAD_LEFT);
        this.addSupportedButton(buttons, (short)8, XInputButton.DPAD_RIGHT);
        if (XInputNatives.isGuideButtonSupported()) {
            this.supportedButtons.add(XInputButton.GUIDE_BUTTON);
        }
        this.resolutions = new XInputCapsResolutions(buffer);
    }

    public XInputDeviceType getType() {
        return this.type;
    }

    public XInputDeviceSubType getSubType() {
        return this.subType;
    }

    public boolean isForceFeedbackSupported() {
        return this.forceFeedbackSupported;
    }

    public boolean isWireless() {
        return this.wireless;
    }

    public boolean isVoiceSupported() {
        return this.voiceSupported;
    }

    public boolean isPluginModulesSupported() {
        return this.pluginModulesSupported;
    }

    public boolean isNoNavigation() {
        return this.noNavigation;
    }

    public EnumSet<XInputButton> getSupportedButtons() {
        return this.supportedButtons;
    }

    public XInputCapsResolutions getResolutions() {
        return this.resolutions;
    }

    private void addSupportedButton(short buttons, short bit, XInputButton button) {
        if ((buttons & bit) == bit) {
            this.supportedButtons.add(button);
        }
    }
}

