/*
 * Decompiled with CFR 0.152.
 */
package com.ivan.xinput;

import com.ivan.xinput.XInputButtons;
import com.ivan.xinput.enums.XInputButton;

public class XInputButtonsDelta {
    private final XInputButtons lastButtons;
    private final XInputButtons buttons;

    protected XInputButtonsDelta(XInputButtons lastButtons, XInputButtons buttons) {
        this.lastButtons = lastButtons;
        this.buttons = buttons;
    }

    public boolean isPressed(XInputButton button) {
        return this.delta(this.lastButtons, this.buttons, button);
    }

    public boolean isReleased(XInputButton button) {
        return this.delta(this.buttons, this.lastButtons, button);
    }

    private boolean delta(XInputButtons from, XInputButtons to, XInputButton button) {
        switch (button) {
            case A: {
                return !from.a && to.a;
            }
            case B: {
                return !from.b && to.b;
            }
            case X: {
                return !from.x && to.x;
            }
            case Y: {
                return !from.y && to.y;
            }
            case BACK: {
                return !from.back && to.back;
            }
            case START: {
                return !from.start && to.start;
            }
            case LEFT_SHOULDER: {
                return !from.lShoulder && to.lShoulder;
            }
            case RIGHT_SHOULDER: {
                return !from.rShoulder && to.rShoulder;
            }
            case LEFT_THUMBSTICK: {
                return !from.lThumb && to.lThumb;
            }
            case RIGHT_THUMBSTICK: {
                return !from.rThumb && to.rThumb;
            }
            case DPAD_UP: {
                return !from.up && to.up;
            }
            case DPAD_DOWN: {
                return !from.down && to.down;
            }
            case DPAD_LEFT: {
                return !from.left && to.left;
            }
            case DPAD_RIGHT: {
                return !from.right && to.right;
            }
            case GUIDE_BUTTON: {
                return !from.guide && to.guide;
            }
            case UNKNOWN: {
                return !from.unknown && to.unknown;
            }
        }
        return false;
    }
}

