/*
 * Decompiled with CFR 0.152.
 */
package com.ivan.xinput;

import com.ivan.xinput.XInputAxes;
import com.ivan.xinput.enums.XInputAxis;

public class XInputAxesDelta {
    private final XInputAxes lastAxes;
    private final XInputAxes axes;

    protected XInputAxesDelta(XInputAxes lastAxes, XInputAxes axes) {
        this.lastAxes = lastAxes;
        this.axes = axes;
    }

    public float getLXDelta() {
        return this.lastAxes.lx - this.axes.lx;
    }

    public float getLYDelta() {
        return this.lastAxes.ly - this.axes.ly;
    }

    public float getRXDelta() {
        return this.lastAxes.rx - this.axes.rx;
    }

    public float getRYDelta() {
        return this.lastAxes.ry - this.axes.ry;
    }

    public float getLTDelta() {
        return this.lastAxes.lt - this.axes.lt;
    }

    public float getRTDelta() {
        return this.lastAxes.rt - this.axes.rt;
    }

    public int getLXRawDelta() {
        return this.lastAxes.lxRaw - this.axes.lxRaw;
    }

    public int getLYRawDelta() {
        return this.lastAxes.lyRaw - this.axes.lyRaw;
    }

    public int getRXRawDelta() {
        return this.lastAxes.rxRaw - this.axes.rxRaw;
    }

    public int getRYRawDelta() {
        return this.lastAxes.ryRaw - this.axes.ryRaw;
    }

    public int getLTRawDelta() {
        return this.lastAxes.ltRaw - this.axes.ltRaw;
    }

    public int getRTRawDelta() {
        return this.lastAxes.rtRaw - this.axes.rtRaw;
    }

    public float getDelta(XInputAxis axis) {
        switch (axis) {
            case LEFT_THUMBSTICK_X: {
                return this.getLXDelta();
            }
            case LEFT_THUMBSTICK_Y: {
                return this.getLYDelta();
            }
            case RIGHT_THUMBSTICK_X: {
                return this.getRXDelta();
            }
            case RIGHT_THUMBSTICK_Y: {
                return this.getRYDelta();
            }
            case LEFT_TRIGGER: {
                return this.getLTDelta();
            }
            case RIGHT_TRIGGER: {
                return this.getRTDelta();
            }
        }
        return 0.0f;
    }

    public int getRawDelta(XInputAxis axis) {
        switch (axis) {
            case LEFT_THUMBSTICK_X: {
                return this.getLXRawDelta();
            }
            case LEFT_THUMBSTICK_Y: {
                return this.getLYRawDelta();
            }
            case RIGHT_THUMBSTICK_X: {
                return this.getRXRawDelta();
            }
            case RIGHT_THUMBSTICK_Y: {
                return this.getRYRawDelta();
            }
            case LEFT_TRIGGER: {
                return this.getLTRawDelta();
            }
            case RIGHT_TRIGGER: {
                return this.getRTRawDelta();
            }
        }
        return 0;
    }
}

