/*
 * Decompiled with CFR 0.152.
 */
package com.ivan.xinput;

import com.ivan.xinput.enums.XInputAxis;

public class XInputAxes {
    public int lxRaw;
    public int lyRaw;
    public int rxRaw;
    public int ryRaw;
    public int ltRaw;
    public int rtRaw;
    public float lx;
    public float ly;
    public float rx;
    public float ry;
    public float lt;
    public float rt;
    public int dpad;
    public static final int DPAD_CENTER = -1;
    public static final int DPAD_UP_LEFT = 0;
    public static final int DPAD_UP = 1;
    public static final int DPAD_UP_RIGHT = 2;
    public static final int DPAD_RIGHT = 3;
    public static final int DPAD_DOWN_RIGHT = 4;
    public static final int DPAD_DOWN = 5;
    public static final int DPAD_DOWN_LEFT = 6;
    public static final int DPAD_LEFT = 7;

    protected XInputAxes() {
        this.reset();
    }

    public float get(XInputAxis axis) {
        switch (axis) {
            case LEFT_THUMBSTICK_X: {
                return this.lx;
            }
            case LEFT_THUMBSTICK_Y: {
                return this.ly;
            }
            case RIGHT_THUMBSTICK_X: {
                return this.rx;
            }
            case RIGHT_THUMBSTICK_Y: {
                return this.ry;
            }
            case LEFT_TRIGGER: {
                return this.lt;
            }
            case RIGHT_TRIGGER: {
                return this.rt;
            }
            case DPAD: {
                return this.dpad;
            }
        }
        return 0.0f;
    }

    public int getRaw(XInputAxis axis) {
        switch (axis) {
            case LEFT_THUMBSTICK_X: {
                return this.lxRaw;
            }
            case LEFT_THUMBSTICK_Y: {
                return this.lyRaw;
            }
            case RIGHT_THUMBSTICK_X: {
                return this.rxRaw;
            }
            case RIGHT_THUMBSTICK_Y: {
                return this.ryRaw;
            }
            case LEFT_TRIGGER: {
                return this.ltRaw;
            }
            case RIGHT_TRIGGER: {
                return this.rtRaw;
            }
            case DPAD: {
                return this.dpad;
            }
        }
        return 0;
    }

    protected void reset() {
        this.lyRaw = 0;
        this.lxRaw = 0;
        this.ryRaw = 0;
        this.rxRaw = 0;
        this.rtRaw = 0;
        this.ltRaw = 0;
        this.ly = 0.0f;
        this.lx = 0.0f;
        this.ry = 0.0f;
        this.rx = 0.0f;
        this.rt = 0.0f;
        this.lt = 0.0f;
        this.dpad = -1;
    }

    protected void copy(XInputAxes axes) {
        this.lxRaw = axes.lxRaw;
        this.lyRaw = axes.lyRaw;
        this.rxRaw = axes.rxRaw;
        this.ryRaw = axes.ryRaw;
        this.ltRaw = axes.ltRaw;
        this.rtRaw = axes.rtRaw;
        this.lx = axes.lx;
        this.ly = axes.ly;
        this.rx = axes.rx;
        this.ry = axes.ry;
        this.lt = axes.lt;
        this.rt = axes.rt;
        this.dpad = axes.dpad;
    }

    public static int dpadFromButtons(boolean up, boolean down, boolean left, boolean right) {
        boolean u = up;
        boolean d = down;
        boolean l = left;
        boolean r = right;
        if (u && d) {
            d = false;
            u = false;
        }
        if (l && r) {
            r = false;
            l = false;
        }
        if (u) {
            if (l) {
                return 0;
            }
            if (r) {
                return 2;
            }
            return 1;
        }
        if (d) {
            if (l) {
                return 6;
            }
            if (r) {
                return 4;
            }
            return 5;
        }
        if (l) {
            return 7;
        }
        if (r) {
            return 3;
        }
        return -1;
    }
}

