/*
 * Decompiled with CFR 0.152.
 */
package com.TominoCZ.FBP.particle;

import com.TominoCZ.FBP.FBP;
import com.TominoCZ.FBP.keys.FBPKeyBindings;
import com.TominoCZ.FBP.util.FBPMathUtil;
import com.TominoCZ.FBP.vector.FBPVector3d;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FBPParticleDigging
extends ParticleDigging {
    private final IBlockState sourceState;
    Minecraft mc = Minecraft.func_71410_x();
    int vecIndex;
    double scaleAlpha;
    double prevParticleScale;
    double prevParticleAlpha;
    double prevMotionX;
    double prevMotionZ;
    boolean modeDebounce = false;
    boolean wasFrozen = false;
    boolean destroyed = false;
    boolean spawned = false;
    boolean dying = false;
    boolean killToggle = false;
    FBPVector3d rotStep;
    FBPVector3d rot;
    FBPVector3d prevRot;
    Vec2f[] par;
    double endMult = 1.0;
    float brightness = 1.0f;
    long tick = 0L;

    protected FBPParticleDigging(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, IBlockState state, @Nullable EnumFacing facing, float scale, @Nullable TextureAtlasSprite texture) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, state);
        try {
            FBP.setSourcePos.invokeExact(this, new BlockPos(xCoordIn, yCoordIn, zCoordIn));
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
        this.rot = new FBPVector3d();
        this.prevRot = new FBPVector3d();
        this.createRotationMatrix();
        if (scale > -1.0f) {
            this.field_70544_f = scale;
        }
        if (scale < -1.0f && facing != null) {
            this.tick = 0L;
            if (facing == EnumFacing.UP && FBP.smartBreaking) {
                this.field_187129_i *= 1.18;
                this.field_187130_j *= -0.15;
                this.field_187131_k *= 1.18;
                double particleSpeed = Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k);
                double x = FBPMathUtil.add(FBPParticleDigging.field_190016_K.field_72450_a, 0.001);
                double z = FBPMathUtil.add(FBPParticleDigging.field_190016_K.field_72449_c, 0.001);
                this.field_187129_i = x * particleSpeed;
                this.field_187131_k = z * particleSpeed;
            }
        }
        if (this.modeDebounce = !FBP.randomRotation) {
            this.rot.zero();
            this.calculateYAngle();
        }
        this.sourceState = state;
        Block b = state.func_177230_c();
        this.field_70545_g = (float)((double)b.field_149763_I * FBP.gravityMult);
        this.field_70544_f = (float)((double)this.field_70544_f * (FBP.scaleMult * 2.0));
        this.field_70547_e = (int)FBP.random.nextDouble(FBP.minAge, (double)FBP.maxAge + 0.5);
        this.field_70553_i = this.field_70551_j = 0.7f + 0.25f * this.mc.field_71474_y.field_74333_Y;
        this.field_70552_h = this.field_70551_j;
        this.scaleAlpha = (double)this.field_70544_f * 0.9;
        boolean bl = this.destroyed = facing == null;
        if (texture == null) {
            BlockModelShapes blockModelShapes = this.mc.func_175602_ab().func_175023_a();
            if (!this.destroyed) {
                try {
                    List quads = blockModelShapes.func_178125_b(state).func_188616_a(state, facing, 0L);
                    if (quads != null && !quads.isEmpty()) {
                        this.field_187119_C = ((BakedQuad)quads.get(0)).func_187508_a();
                        if (!state.func_185915_l() || b.equals(Blocks.field_150349_c) && facing.equals((Object)EnumFacing.UP)) {
                            this.func_187154_b(new BlockPos(xCoordIn, yCoordIn, zCoordIn));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.field_187119_C == null || this.field_187119_C.func_94215_i() == "missingno") {
                this.func_187117_a(blockModelShapes.func_178122_a(state));
            }
        } else {
            this.field_187119_C = texture;
        }
        if (!state.func_185915_l()) {
            this.func_187154_b(new BlockPos(xCoordIn, yCoordIn, zCoordIn));
        }
        if (FBP.randomFadingSpeed) {
            this.endMult = FBP.random.nextDouble(0.7, 1.0);
        }
    }

    public Particle MultiplyVelocity(float multiplier) {
        this.field_187129_i *= (double)multiplier;
        this.field_187130_j = (this.field_187130_j - (double)0.1f) * (double)(multiplier / 2.0f) + (double)0.1f;
        this.field_187131_k *= (double)multiplier;
        return this;
    }

    protected void func_187154_b(@Nullable BlockPos p_187154_1_) {
        int i = this.mc.func_184125_al().func_186724_a(this.sourceState, (IBlockAccess)this.field_187122_b, p_187154_1_, 0);
        this.field_70552_h *= (float)(i >> 16 & 0xFF) / 255.0f;
        this.field_70553_i *= (float)(i >> 8 & 0xFF) / 255.0f;
        this.field_70551_j *= (float)(i & 0xFF) / 255.0f;
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_189213_a() {
        if (!this.spawned) {
            ++this.tick;
        }
        if (!FBP.frozen && FBP.bounceOffWalls && !this.mc.func_147113_T()) {
            if (!this.wasFrozen && this.spawned && (double)MathHelper.func_76135_e((float)((float)this.field_187129_i)) > 1.0E-5) {
                boolean zCollided;
                boolean xCollided = this.field_187123_c == this.field_187126_f;
                boolean bl = zCollided = this.field_187125_e == this.field_187128_h;
                if (xCollided) {
                    this.field_187129_i = -this.prevMotionX;
                }
                if (zCollided) {
                    this.field_187131_k = -this.prevMotionZ;
                }
                if (!FBP.randomRotation && (xCollided || zCollided)) {
                    this.calculateYAngle();
                }
            } else {
                this.wasFrozen = false;
            }
        }
        if (FBP.frozen && FBP.bounceOffWalls && !this.wasFrozen) {
            this.wasFrozen = true;
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevRot.copyFrom(this.rot);
        this.prevParticleAlpha = this.field_82339_as;
        this.prevParticleScale = this.field_70544_f;
        if (!(this.mc.func_147113_T() || FBP.frozen && !this.killToggle)) {
            boolean allowedToMove;
            boolean bl = allowedToMove = (double)MathHelper.func_76135_e((float)((float)this.field_187129_i)) > 1.0E-5;
            if (!this.killToggle) {
                if (!FBP.randomRotation) {
                    if (!this.modeDebounce) {
                        this.modeDebounce = true;
                        this.rot.field_181061_c = 0.0;
                        this.calculateYAngle();
                    }
                    if (allowedToMove) {
                        double x = MathHelper.func_76135_e((float)((float)(this.rotStep.field_181059_a * this.getMult() * FBP.rotationMult)));
                        if (this.field_187129_i > 0.0) {
                            if (this.field_187131_k > 0.0) {
                                this.rot.field_181059_a -= x;
                            } else if (this.field_187131_k < 0.0) {
                                this.rot.field_181059_a += x;
                            }
                        } else if (this.field_187129_i < 0.0) {
                            if (this.field_187131_k < 0.0) {
                                this.rot.field_181059_a += x;
                            } else if (this.field_187131_k > 0.0) {
                                this.rot.field_181059_a -= x;
                            }
                        }
                    }
                } else {
                    if (this.modeDebounce) {
                        this.modeDebounce = false;
                        this.createRotationMatrix();
                    }
                    if (allowedToMove) {
                        this.rot.add(this.rotStep.multiply(this.getMult() * FBP.rotationMult));
                    }
                }
            }
            if (!FBP.infiniteDuration) {
                ++this.field_70546_d;
            }
            if (this.field_70546_d >= this.field_70547_e || this.killToggle) {
                if (!this.dying) {
                    this.dying = true;
                }
                this.field_70544_f = FBP.randomFadingSpeed ? (float)((double)this.field_70544_f * ((double)0.95f * this.endMult)) : (this.field_70544_f *= 0.95f);
                if ((double)this.field_82339_as > 0.01 && (double)this.field_70544_f <= this.scaleAlpha) {
                    this.field_82339_as = FBP.randomFadingSpeed ? (float)((double)this.field_82339_as * ((double)0.65f * this.endMult)) : (this.field_82339_as *= 0.65f);
                }
                if ((double)this.field_82339_as <= 0.01) {
                    this.func_187112_i();
                }
            }
            if (!this.killToggle) {
                this.field_187130_j = this.field_187132_l ? -0.08322508594922069 : (this.field_187130_j -= 0.04 * (double)this.field_70545_g);
                if (allowedToMove) {
                    this.moveEntity(this.field_187129_i, this.field_187130_j, this.field_187131_k, false);
                } else {
                    this.moveEntity(0.0, this.field_187130_j, 0.0, true);
                }
                if ((double)MathHelper.func_76135_e((float)((float)this.field_187129_i)) > 1.0E-5) {
                    this.prevMotionX = this.field_187129_i;
                    this.prevMotionZ = this.field_187131_k;
                }
                if (allowedToMove) {
                    this.field_187129_i *= (double)0.98f;
                    this.field_187131_k *= (double)0.98f;
                }
                this.field_187130_j *= (double)0.98f;
                if (FBP.entityCollision) {
                    List list = this.field_187122_b.func_72872_a(Entity.class, this.func_187116_l());
                    for (Entity entityIn : list) {
                        double d1;
                        double d0;
                        double d2;
                        if (entityIn.field_70145_X || !((d2 = MathHelper.func_76132_a((double)(d0 = this.field_187126_f - entityIn.field_70165_t), (double)(d1 = this.field_187128_h - entityIn.field_70161_v))) >= (double)0.01f)) continue;
                        d2 = Math.sqrt(d2);
                        d0 /= d2;
                        d1 /= d2;
                        double d3 = 1.0 / d2;
                        if (d3 > 1.0) {
                            d3 = 1.0;
                        }
                        this.field_187129_i += d0 * d3 / 20.0;
                        this.field_187131_k += d1 * d3 / 20.0;
                        if (!FBP.randomRotation) {
                            this.calculateYAngle();
                        }
                        if (FBP.frozen) continue;
                        this.field_187132_l = false;
                    }
                }
                if (this.field_187132_l) {
                    if (FBP.rollParticles) {
                        this.field_187129_i *= 0.932515086137662;
                        this.field_187131_k *= 0.932515086137662;
                    } else {
                        this.field_187129_i *= 0.654999988079071;
                        this.field_187131_k *= 0.654999988079071;
                    }
                }
            }
        }
        if (this.destroyed || !this.spawned && this.tick >= 2L) {
            this.spawned = true;
        }
    }

    public void moveEntity(double x, double y, double z, boolean YOnly) {
        double X = x;
        double Y = y;
        double Z = z;
        double d0 = y;
        if (this.field_190017_n) {
            List list = this.field_187122_b.func_184144_a(null, this.func_187116_l().func_72317_d(x, y, z));
            for (AxisAlignedBB aabb : list) {
                y = aabb.func_72323_b(this.func_187116_l(), y);
                if (YOnly) continue;
                x = aabb.func_72316_a(this.func_187116_l(), x);
                z = aabb.func_72322_c(this.func_187116_l(), z);
            }
            this.func_187108_a(this.func_187116_l().func_72317_d(YOnly ? 0.0 : x, y, YOnly ? 0.0 : z));
        } else {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        }
        this.func_187118_j();
        boolean bl = this.field_187132_l = y != Y && d0 < 0.0;
        if (!FBP.rollParticles && !FBP.bounceOffWalls) {
            if (x != X) {
                this.field_187129_i *= (double)0.7f;
            }
            if (z != Z) {
                this.field_187131_k *= (double)0.7f;
            }
        }
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!FBP.isEnabled() && this.field_70547_e != 0) {
            this.field_70547_e = 0;
        }
        if (FBPKeyBindings.FBPSweep.func_151470_d() && !this.killToggle) {
            this.killToggle = true;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = this.field_70544_f;
        if (this.field_187119_C != null) {
            if (!FBP.cartoonMode) {
                f = this.field_187119_C.func_94214_a((double)(this.field_70548_b / 4.0f * 16.0f));
                f2 = this.field_187119_C.func_94207_b((double)(this.field_70549_c / 4.0f * 16.0f));
            }
            f1 = this.field_187119_C.func_94214_a((double)((this.field_70548_b + 1.0f) / 4.0f * 16.0f));
            f3 = this.field_187119_C.func_94207_b((double)((this.field_70549_c + 1.0f) / 4.0f * 16.0f));
        } else {
            f = ((float)this.field_94054_b + this.field_70548_b / 4.0f) / 16.0f;
            f1 = f + 0.015609375f;
            f2 = ((float)this.field_94055_c + this.field_70549_c / 4.0f) / 16.0f;
            f3 = f2 + 0.015609375f;
        }
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao) + 0.01275f;
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        this.par = new Vec2f[]{new Vec2f(f1, f3), new Vec2f(f1, f2), new Vec2f(f, f2), new Vec2f(f, f3)};
        float alpha = this.field_82339_as;
        if (this.dying && FBP.smoothTransitions && !FBP.frozen || FBP.frozen && this.killToggle && FBP.smoothTransitions) {
            f4 = (float)(this.prevParticleScale + ((double)this.field_70544_f - this.prevParticleScale) * (double)partialTicks);
            alpha = (float)(this.prevParticleAlpha + ((double)this.field_82339_as - this.prevParticleAlpha) * (double)partialTicks);
        }
        FBPVector3d smoothRot = new FBPVector3d(0.0, 0.0, 0.0);
        if (FBP.rotationMult > 0.0) {
            smoothRot.field_181060_b = this.rot.field_181060_b;
            smoothRot.field_181061_c = this.rot.field_181061_c;
            if (!FBP.randomRotation) {
                smoothRot.field_181059_a = this.rot.field_181059_a;
            }
            if (FBP.smoothTransitions && !FBP.frozen) {
                FBPVector3d vec = this.rot.partialVec(this.prevRot, partialTicks);
                if (FBP.randomRotation) {
                    smoothRot.field_181060_b = vec.field_181060_b;
                    smoothRot.field_181061_c = vec.field_181061_c;
                } else {
                    smoothRot.field_181059_a = vec.field_181059_a;
                }
            }
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        worldRendererIn.func_178969_c((double)f5, (double)f6, (double)f7);
        if (this.spawned) {
            this.putCube(worldRendererIn, f4 / 20.0f, smoothRot, i >> 16 & 0xFFFF, i & 0xFFFF, this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha, FBP.cartoonMode);
        }
        worldRendererIn.func_178969_c(0.0, 0.0, 0.0);
    }

    public void putCube(BufferBuilder worldRendererIn, double scale, FBPVector3d rotVec, int j, int k, float r, float g, float b, float a, boolean cartoon) {
        this.brightness = 1.0f;
        float R = 0.0f;
        float G = 0.0f;
        float B = 0.0f;
        float radsX = (float)Math.toRadians(rotVec.field_181059_a);
        float radsY = (float)Math.toRadians(rotVec.field_181060_b);
        float radsZ = (float)Math.toRadians(rotVec.field_181061_c);
        for (int i = 0; i < FBP.CUBE.length; i += 4) {
            Vec3d v1 = FBP.CUBE[i];
            Vec3d v2 = FBP.CUBE[i + 1];
            Vec3d v3 = FBP.CUBE[i + 2];
            Vec3d v4 = FBP.CUBE[i + 3];
            v1 = this.rotatef(v1, radsX, radsY, radsZ);
            v2 = this.rotatef(v2, radsX, radsY, radsZ);
            v3 = this.rotatef(v3, radsX, radsY, radsZ);
            v4 = this.rotatef(v4, radsX, radsY, radsZ);
            R = r * this.brightness;
            G = g * this.brightness;
            B = b * this.brightness;
            this.brightness = (float)((double)this.brightness * 0.935);
            if (!cartoon) {
                this.addVt(worldRendererIn, scale, v1, this.par[0].field_189982_i, this.par[0].field_189983_j, j, k, R, G, B, a);
                this.addVt(worldRendererIn, scale, v2, this.par[1].field_189982_i, this.par[1].field_189983_j, j, k, R, G, B, a);
                this.addVt(worldRendererIn, scale, v3, this.par[2].field_189982_i, this.par[2].field_189983_j, j, k, R, G, B, a);
                this.addVt(worldRendererIn, scale, v4, this.par[3].field_189982_i, this.par[3].field_189983_j, j, k, R, G, B, a);
                continue;
            }
            this.addVt(worldRendererIn, scale, v1, this.par[0].field_189982_i, this.par[0].field_189983_j, j, k, R, G, B, a);
            this.addVt(worldRendererIn, scale, v2, this.par[0].field_189982_i, this.par[0].field_189983_j, j, k, R, G, B, a);
            this.addVt(worldRendererIn, scale, v3, this.par[0].field_189982_i, this.par[0].field_189983_j, j, k, R, G, B, a);
            this.addVt(worldRendererIn, scale, v4, this.par[0].field_189982_i, this.par[0].field_189983_j, j, k, R, G, B, a);
        }
    }

    private void addVt(BufferBuilder worldRendererIn, double scale, Vec3d pos, double u, double v, int j, int k, float r, float g, float b, float a) {
        worldRendererIn.func_181662_b(pos.field_72450_a * scale, pos.field_72448_b * scale, pos.field_72449_c * scale).func_187315_a(u, v).func_181666_a(r, g, b, a).func_187314_a(j, k).func_181675_d();
    }

    Vec3d rotatef(Vec3d vec, float AngleX, float AngleY, float AngleZ) {
        FBPVector3d sin = new FBPVector3d(MathHelper.func_76126_a((float)AngleX), MathHelper.func_76126_a((float)AngleY), MathHelper.func_76126_a((float)AngleZ));
        FBPVector3d cos = new FBPVector3d(MathHelper.func_76134_b((float)AngleX), MathHelper.func_76134_b((float)AngleY), MathHelper.func_76134_b((float)AngleZ));
        vec = new Vec3d(vec.field_72450_a, vec.field_72448_b * cos.field_181059_a - vec.field_72449_c * sin.field_181059_a, vec.field_72448_b * sin.field_181059_a + vec.field_72449_c * cos.field_181059_a);
        vec = new Vec3d(vec.field_72450_a * cos.field_181060_b + vec.field_72449_c * sin.field_181060_b, vec.field_72448_b, vec.field_72450_a * sin.field_181060_b - vec.field_72449_c * cos.field_181060_b);
        vec = new Vec3d(vec.field_72450_a * cos.field_181061_c - vec.field_72448_b * sin.field_181061_c, vec.field_72450_a * sin.field_181061_c + vec.field_72448_b * cos.field_181061_c, vec.field_72449_c);
        return vec;
    }

    private void createRotationMatrix() {
        double rx = FBP.random.nextDouble();
        double ry = FBP.random.nextDouble();
        double rz = FBP.random.nextDouble();
        this.rotStep = new FBPVector3d(rx > 0.5 ? 1.0 : -1.0, ry > 0.5 ? 1.0 : -1.0, rz > 0.5 ? 1.0 : -1.0);
        this.rot.copyFrom(this.rotStep);
    }

    public int func_189214_a(float p_189214_1_) {
        int i = super.func_189214_a(p_189214_1_);
        int j = 0;
        if (this.field_187122_b.func_175667_e(new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h))) {
            j = this.field_187122_b.func_175626_b(new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h), 0);
        }
        return i == 0 ? j : i;
    }

    private void calculateYAngle() {
        double angleSin = Math.toDegrees(Math.asin(this.field_187129_i / Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k)));
        this.rot.field_181060_b = this.field_187129_i > 0.0 ? (this.field_187131_k > 0.0 ? -angleSin : angleSin) : (this.field_187131_k > 0.0 ? -angleSin : angleSin);
    }

    double getMult() {
        if (FBP.randomRotation) {
            if (this.destroyed) {
                return Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k) * 200.0;
            }
            return Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k) * 300.0;
        }
        if (FBP.rollParticles) {
            if (this.destroyed) {
                return Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k) * 300.0;
            }
            return Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k) * 1150.0;
        }
        if (this.destroyed) {
            return Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k) * 300.0;
        }
        return Math.sqrt(this.field_187129_i * this.field_187129_i + this.field_187131_k * this.field_187131_k) * 1000.0;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... p_178902_15_) {
            return new FBPParticleDigging(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, Block.func_176220_d((int)p_178902_15_[0]), null, -1.0f, null).func_174845_l();
        }
    }
}

