/*
 * Decompiled with CFR 0.152.
 */
package com.TominoCZ.FBP.model;

import com.TominoCZ.FBP.model.FBPSimpleBakedModel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public final class FBPModelTransformer {
    private FBPModelTransformer() {
    }

    public static FBPSimpleBakedModel transform(IBakedModel model, IBlockState state, long rand, IVertexTransformer transformer) {
        try {
            FBPSimpleBakedModel out = new FBPSimpleBakedModel(model);
            for (int i = 0; i <= 6; ++i) {
                EnumFacing side = i == 6 ? null : EnumFacing.func_82600_a((int)i);
                for (BakedQuad quad : model.func_188616_a(state, side, rand)) {
                    out.addQuad(side, FBPModelTransformer.transform(quad, transformer));
                }
            }
            return out;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static BakedQuad transform(BakedQuad quad, IVertexTransformer transformer) {
        VertexFormat format = quad.getFormat();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        LightUtil.putBakedQuad((IVertexConsumer)new VertexTransformerWrapper((IVertexConsumer)builder, quad, transformer), (BakedQuad)quad);
        return builder.build();
    }

    public static interface IVertexTransformer {
        public float[] transform(BakedQuad var1, VertexFormatElement var2, float ... var3);
    }

    private static final class VertexTransformerWrapper
    implements IVertexConsumer {
        private final IVertexConsumer parent;
        private final BakedQuad parentQuad;
        private final VertexFormat format;
        private final IVertexTransformer transformer;

        public VertexTransformerWrapper(IVertexConsumer parent, BakedQuad parentQuad, IVertexTransformer transformer) {
            this.parent = parent;
            this.parentQuad = parentQuad;
            this.format = parent.getVertexFormat();
            this.transformer = transformer;
        }

        public VertexFormat getVertexFormat() {
            return this.format;
        }

        public void setQuadTint(int tint) {
            this.parent.setQuadTint(tint);
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.parent.setQuadOrientation(orientation);
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.parent.setApplyDiffuseLighting(diffuse);
        }

        public void setTexture(TextureAtlasSprite texture) {
            this.parent.setTexture(texture);
        }

        public void put(int elementId, float ... data) {
            VertexFormatElement element = this.format.func_177348_c(elementId);
            this.parent.put(elementId, this.transformer.transform(this.parentQuad, element, data));
        }
    }
}

