/*
 * Decompiled with CFR 0.152.
 */
package com.TominoCZ.FBP.handler;

import com.TominoCZ.FBP.FBP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import scala.reflect.io.Directory;

public class FBPConfigHandler {
    static FileInputStream fis;
    static InputStreamReader isr;
    static BufferedReader br;
    static File configFile;
    static File exceptionsFile;

    public static void init() {
        try {
            configFile = FBP.config;
            exceptionsFile = FBP.exceptionsFile;
            FBPConfigHandler.defaults(false);
            if (!configFile.exists()) {
                if (!Directory.apply((String)configFile.getParent()).exists()) {
                    Directory.apply((String)configFile.getParent()).createDirectory(true, false);
                }
                configFile.createNewFile();
                FBPConfigHandler.write();
            }
            if (!exceptionsFile.exists()) {
                if (!Directory.apply((String)exceptionsFile.getParent()).exists()) {
                    Directory.apply((String)exceptionsFile.getParent()).createDirectory(true, false);
                }
                exceptionsFile.createNewFile();
                FBPConfigHandler.writeExceptions();
            }
            FBPConfigHandler.read();
            FBPConfigHandler.readExceptions();
            FBPConfigHandler.write();
            FBPConfigHandler.writeExceptions();
            FBPConfigHandler.closeStreams();
        }
        catch (IOException e) {
            FBPConfigHandler.closeStreams();
            FBPConfigHandler.write();
        }
    }

    public static void write() {
        try {
            FBPConfigHandler.check();
            PrintWriter writer = new PrintWriter(configFile.getPath(), "UTF-8");
            writer.println("enabled=" + FBP.enabled);
            writer.println("fancyFlame=" + FBP.fancyFlame);
            writer.println("fancySmoke=" + FBP.fancySmoke);
            writer.println("fancyWeather=" + FBP.fancyWeather);
            writer.println("fancyPlaceAnim=" + FBP.fancyPlaceAnim);
            writer.println("smartBreaking=" + FBP.smartBreaking);
            writer.println("rollParticles=" + FBP.rollParticles);
            writer.println("bounceOffWalls=" + FBP.bounceOffWalls);
            writer.println("showInMillis=" + FBP.showInMillis);
            writer.println("randomRotation=" + FBP.randomRotation);
            writer.println("cartoonMode=" + FBP.cartoonMode);
            writer.println("entityCollision=" + FBP.entityCollision);
            writer.println("smoothTransitions=" + FBP.smoothTransitions);
            writer.println("randomFadingSpeed=" + FBP.randomFadingSpeed);
            writer.println("spawnRedstoneBlockParticles=" + FBP.spawnRedstoneBlockParticles);
            writer.println("spawnWhileFrozen=" + FBP.spawnWhileFrozen);
            writer.println("infiniteDuration=" + FBP.infiniteDuration);
            writer.println("minAge=" + FBP.minAge);
            writer.println("maxAge=" + FBP.maxAge);
            writer.println("scaleMult=" + FBP.scaleMult);
            writer.println("gravityMult=" + FBP.gravityMult);
            writer.print("rotationMult=" + FBP.rotationMult);
            writer.close();
        }
        catch (Exception e) {
            FBPConfigHandler.closeStreams();
            if (!configFile.exists()) {
                if (!Directory.apply((String)configFile.getParent()).exists()) {
                    Directory.apply((String)configFile.getParent()).createDirectory(true, false);
                }
                try {
                    configFile.createNewFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            FBPConfigHandler.write();
        }
    }

    public static void writeExceptions() {
        block6: {
            try {
                PrintWriter writer = new PrintWriter(exceptionsFile.getPath(), "UTF-8");
                for (String ex : FBP.INSTANCE.blockExceptions) {
                    writer.println(ex);
                }
                writer.close();
            }
            catch (Exception e) {
                FBPConfigHandler.closeStreams();
                if (exceptionsFile.exists()) break block6;
                if (!Directory.apply((String)exceptionsFile.getParent()).exists()) {
                    Directory.apply((String)exceptionsFile.getParent()).createDirectory(true, false);
                }
                try {
                    exceptionsFile.createNewFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    static void read() {
        try {
            String line;
            fis = new FileInputStream(configFile);
            isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if (line.contains("enabled=")) {
                    FBP.enabled = Boolean.valueOf(line.replaceAll(" ", "").replace("enabled=", ""));
                    continue;
                }
                if (line.contains("fancyFlame=")) {
                    FBP.fancyFlame = Boolean.valueOf(line.replaceAll(" ", "").replace("fancyFlame=", ""));
                    continue;
                }
                if (line.contains("fancySmoke=")) {
                    FBP.fancySmoke = Boolean.valueOf(line.replaceAll(" ", "").replace("fancySmoke=", ""));
                    continue;
                }
                if (line.contains("fancyWeather=")) {
                    FBP.fancyWeather = Boolean.valueOf(line.replaceAll(" ", "").replace("fancyWeather=", ""));
                    continue;
                }
                if (line.contains("fancyPlaceAnim=")) {
                    FBP.fancyPlaceAnim = Boolean.valueOf(line.replaceAll(" ", "").replace("fancyPlaceAnim=", ""));
                    continue;
                }
                if (line.contains("smartBreaking=")) {
                    FBP.smartBreaking = Boolean.valueOf(line.replaceAll(" ", "").replace("smartBreaking=", ""));
                    continue;
                }
                if (line.contains("rollParticles=")) {
                    FBP.rollParticles = Boolean.valueOf(line.replaceAll(" ", "").replace("rollParticles=", ""));
                    continue;
                }
                if (line.contains("bounceOffWalls=")) {
                    FBP.bounceOffWalls = Boolean.valueOf(line.replaceAll(" ", "").replace("bounceOffWalls=", ""));
                    continue;
                }
                if (line.contains("showInMillis=")) {
                    FBP.showInMillis = Boolean.valueOf(line.replaceAll(" ", "").replace("showInMillis=", ""));
                    continue;
                }
                if (line.contains("randomRotation=")) {
                    FBP.randomRotation = Boolean.valueOf(line.replaceAll(" ", "").replace("randomRotation=", ""));
                    continue;
                }
                if (line.contains("cartoonMode=")) {
                    FBP.cartoonMode = Boolean.valueOf(line.replaceAll(" ", "").replace("cartoonMode=", ""));
                    continue;
                }
                if (line.contains("entityCollision=")) {
                    FBP.entityCollision = Boolean.valueOf(line.replaceAll(" ", "").replace("entityCollision=", ""));
                    continue;
                }
                if (line.contains("randomFadingSpeed=")) {
                    FBP.randomFadingSpeed = Boolean.valueOf(line.replaceAll(" ", "").replace("randomFadingSpeed=", ""));
                    continue;
                }
                if (line.contains("smoothTransitions=")) {
                    FBP.smoothTransitions = Boolean.valueOf(line.replaceAll(" ", "").replace("smoothTransitions=", ""));
                    continue;
                }
                if (line.contains("spawnWhileFrozen=")) {
                    FBP.spawnWhileFrozen = Boolean.valueOf(line.replaceAll(" ", "").replace("spawnWhileFrozen=", ""));
                    continue;
                }
                if (line.contains("spawnRedstoneBlockParticles=")) {
                    FBP.spawnRedstoneBlockParticles = Boolean.valueOf(line.replaceAll(" ", "").replace("spawnRedstoneBlockParticles=", ""));
                    continue;
                }
                if (line.contains("infiniteDuration=")) {
                    FBP.infiniteDuration = Boolean.valueOf(line.replaceAll(" ", "").replace("infiniteDuration=", ""));
                    continue;
                }
                if (line.contains("minAge=")) {
                    FBP.minAge = Integer.valueOf(line.replaceAll(" ", "").replace("minAge=", ""));
                    continue;
                }
                if (line.contains("maxAge=")) {
                    FBP.maxAge = Integer.valueOf(line.replaceAll(" ", "").replace("maxAge=", ""));
                    continue;
                }
                if (line.contains("scaleMult=")) {
                    FBP.scaleMult = Double.valueOf(line.replaceAll(" ", "").replace("scaleMult=", ""));
                    continue;
                }
                if (line.contains("gravityMult=")) {
                    FBP.gravityMult = Double.valueOf(line.replaceAll(" ", "").replace("gravityMult=", ""));
                    continue;
                }
                if (!line.contains("rotationMult=")) continue;
                FBP.rotationMult = Double.valueOf(line.replaceAll(" ", "").replace("rotationMult=", ""));
            }
            FBPConfigHandler.closeStreams();
            FBPConfigHandler.check();
        }
        catch (Exception e) {
            FBPConfigHandler.closeStreams();
            FBPConfigHandler.check();
            FBPConfigHandler.write();
        }
    }

    static void readExceptions() {
        try {
            String line;
            fis = new FileInputStream(exceptionsFile);
            isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            br = new BufferedReader(isr);
            String last = "";
            FBP.INSTANCE.resetExceptions();
            while ((line = br.readLine()) != null && !StringUtils.isEmpty((CharSequence)line)) {
                last = line.replaceAll(" ", "").toLowerCase();
                FBP.INSTANCE.addException(last);
            }
            if (!StringUtils.isEmpty((CharSequence)last)) {
                FBP.lastAdded = last;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        FBPConfigHandler.closeStreams();
    }

    static void closeStreams() {
        try {
            br.close();
            isr.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void defaults(boolean write) {
        FBP.minAge = 10;
        FBP.maxAge = 65;
        FBP.scaleMult = 1.0;
        FBP.gravityMult = 1.0;
        FBP.rotationMult = 1.0;
        FBP.rollParticles = false;
        FBP.bounceOffWalls = true;
        FBP.randomRotation = true;
        FBP.cartoonMode = false;
        FBP.entityCollision = false;
        FBP.smoothTransitions = true;
        FBP.randomFadingSpeed = true;
        FBP.spawnRedstoneBlockParticles = false;
        FBP.infiniteDuration = false;
        FBP.spawnWhileFrozen = true;
        FBP.smartBreaking = true;
        FBP.fancyPlaceAnim = true;
        FBP.fancyWeather = true;
        FBP.fancySmoke = true;
        FBP.fancyFlame = true;
        FBP.INSTANCE.resetExceptions();
        if (write) {
            FBPConfigHandler.write();
            FBPConfigHandler.writeExceptions();
        }
    }

    public static void check() {
        FBP.scaleMult = Math.abs(FBP.scaleMult);
        FBP.minAge = Math.abs(FBP.minAge);
        FBP.maxAge = Math.abs(FBP.maxAge);
        FBP.gravityMult = Math.abs(FBP.gravityMult);
        FBP.rotationMult = Math.abs(FBP.rotationMult);
        if (FBP.minAge < 10) {
            FBP.minAge = 10;
        }
        if (FBP.maxAge < 10) {
            FBP.maxAge = 10;
        } else if (FBP.maxAge > 100) {
            FBP.maxAge = 100;
        }
        FBP.minAge = FBPConfigHandler.fix(FBP.minAge);
        FBP.maxAge = FBPConfigHandler.fix(FBP.maxAge);
        if (FBP.scaleMult > 1.25) {
            FBP.scaleMult = 1.25;
        } else if (FBP.scaleMult < 0.75) {
            FBP.scaleMult = 0.75;
        }
        if (FBP.gravityMult > 2.0) {
            FBP.gravityMult = 2.0;
        } else if (FBP.gravityMult < 0.5) {
            FBP.gravityMult = 0.5;
        }
        if (FBP.rotationMult > 1.5) {
            FBP.rotationMult = 1.5;
        } else if (FBP.rotationMult < 0.0) {
            FBP.rotationMult = 0.0;
        }
        if (FBP.minAge > FBP.maxAge) {
            FBP.minAge = FBP.maxAge;
        }
    }

    private static int fix(int num) {
        for (int i = num; i > 0; --i) {
            if (i % 5 != 0) continue;
            return i;
        }
        return num;
    }
}

