/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals.types;

import com.sonicjumper.enhancedvisuals.EnhancedVisuals;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public abstract class VisualTypeTexture
extends VisualType {
    public int animationSpeed;
    public ResourceLocation[] resources;
    public Dimension dimension;

    public VisualTypeTexture(VisualCategory category, String name, int animationSpeed, boolean isAffectedByWater) {
        super(category, name, isAffectedByWater);
        this.animationSpeed = animationSpeed;
    }

    @Override
    public void loadTextures(IResourceManager manager) {
        String baseLocation = "visuals/" + (Object)((Object)this.category) + "/" + this.name + "/" + this.name;
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        int i = 0;
        ResourceLocation location = null;
        IResource resource = null;
        try {
            while ((resource = manager.func_110536_a(location = new ResourceLocation("enhancedvisuals", baseLocation + i + ".png"))) != null) {
                if (i == 0) {
                    BufferedImage image = ImageIO.read(resource.func_110527_b());
                    this.dimension = new Dimension(image.getWidth(), image.getHeight());
                }
                locations.add(location);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.resources = locations.toArray(new ResourceLocation[0]);
        if (this.resources.length == 0) {
            EnhancedVisuals.log.warn("Could not find any resources for '" + this.name + "'!");
        }
    }

    @Override
    public boolean supportsColor() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.resources.length > 0;
    }

    @Override
    public int getVariantAmount() {
        return this.resources.length;
    }

    public ResourceLocation getResource(Visual visual) {
        if (this.animationSpeed > 0) {
            long time = Math.abs(System.currentTimeMillis() / (long)this.animationSpeed);
            return this.resources[(int)(time % (long)this.resources.length)];
        }
        return this.resources[visual.variant];
    }

    @Override
    public void render(Visual visual, TextureManager manager, ScaledResolution resolution, float partialTicks, float intensity) {
        manager.func_110577_a(this.getResource(visual));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        float red = (float)visual.getColor().getRed() / 255.0f;
        float green = (float)visual.getColor().getGreen() / 255.0f;
        float blue = (float)visual.getColor().getBlue() / 255.0f;
        double z = -90.0;
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        if (visual.properties != null) {
            width = visual.properties.width;
            height = visual.properties.height;
            GlStateManager.func_179109_b((float)(visual.properties.posX + width / 2), (float)(visual.properties.posY + height / 2), (float)0.0f);
            GlStateManager.func_179114_b((float)visual.properties.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        renderer.func_181662_b(0.0, (double)height, z).func_187315_a(0.0, 1.0).func_181666_a(red, green, blue, intensity).func_181675_d();
        renderer.func_181662_b((double)width, (double)height, z).func_187315_a(1.0, 1.0).func_181666_a(red, green, blue, intensity).func_181675_d();
        renderer.func_181662_b((double)width, 0.0, z).func_187315_a(1.0, 0.0).func_181666_a(red, green, blue, intensity).func_181675_d();
        renderer.func_181662_b(0.0, 0.0, z).func_187315_a(0.0, 0.0).func_181666_a(red, green, blue, intensity).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public boolean needsToBeRendered(float intensity) {
        return intensity > 0.0f;
    }
}

