/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.visuals.types;

import com.sonicjumper.enhancedvisuals.addon.toughasnails.ToughAsNailsAddon;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualTypeOverlay;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualTypeShader;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualTypeSplat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public abstract class VisualType {
    public static VisualType splatter = new VisualTypeSplat("splatter", true);
    public static VisualType impact = new VisualTypeSplat("impact", true);
    public static VisualType slash = new VisualTypeSplat("slash", true);
    public static VisualType pierce = new VisualTypeSplat("pierce", true);
    public static VisualType dust = new VisualTypeSplat("dust", true);
    public static VisualType fire = new VisualTypeSplat("fire", true);
    public static VisualType sand = new VisualTypeSplat("sand", true);
    public static VisualType waterS = new VisualTypeSplat("water", false);
    public static VisualType lowhealth = new VisualTypeOverlay("lowhealth", false);
    public static VisualType damaged = new VisualTypeOverlay("damaged", false);
    public static VisualType potion = new VisualTypeOverlay("potion", false);
    public static VisualType slender = new VisualTypeOverlay("slender", 50, false){

        @Override
        public VisualPersistent createPersitentVisual() {
            return new VisualPersistent(this, 0.0f);
        }
    };
    public static VisualType blur = new VisualTypeShader("blur", new ResourceLocation("shaders/post/blur.json"), false){

        @Override
        public VisualPersistent createPersitentVisual() {
            return new VisualPersistent(this, 0.0f);
        }

        @Override
        public void changeProperties(float intensity) {
            for (Shader mcShader : this.shaderGroup.getShaders()) {
                ShaderUniform shaderuniform = mcShader.func_148043_c().func_147991_a("Radius");
                if (shaderuniform == null) continue;
                shaderuniform.func_148090_a((float)Math.floor(intensity));
            }
        }

        @Override
        public boolean needsToBeRendered(float intensity) {
            return Math.floor(intensity) > 0.0;
        }
    };
    public static VisualType desaturate = new VisualTypeShader("desaturate", new ResourceLocation("shaders/post/desaturate.json"), false){

        @Override
        public VisualPersistent createPersitentVisual() {
            return new VisualPersistent(this, 1.0f);
        }

        @Override
        public void changeProperties(float intensity) {
            for (Shader mcShader : this.shaderGroup.getShaders()) {
                ShaderUniform shaderuniform = mcShader.func_148043_c().func_147991_a("Saturation");
                if (shaderuniform == null) continue;
                shaderuniform.func_148090_a(intensity);
            }
        }

        @Override
        public boolean needsToBeRendered(float intensity) {
            return intensity != 1.0f;
        }
    };
    public String name;
    public final boolean isAffectedByWater;
    public final VisualCategory category;
    protected boolean enabled = true;
    public float alpha = 1.0f;

    public static void onLoad() {
        if (Loader.isModLoaded((String)"toughasnails")) {
            ToughAsNailsAddon.load();
        }
    }

    public VisualType(VisualCategory category, String name, boolean isAffectedByWater) {
        this.category = category;
        this.name = name;
        this.isAffectedByWater = isAffectedByWater;
        category.types.add(this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected String getConfigCat() {
        return this.name + "-type";
    }

    public void initConfig(Configuration config) {
        this.enabled = config.getBoolean("enabled", this.getConfigCat(), true, "If the effect is enabled!");
        this.alpha = config.getFloat("alpha", this.getConfigCat(), this.alpha, 0.0f, 1.0f, "");
    }

    public abstract void loadTextures(IResourceManager var1);

    public abstract int getVariantAmount();

    public abstract boolean isRandomized();

    public int getSize() {
        return -1;
    }

    public abstract boolean supportsColor();

    public abstract void render(Visual var1, TextureManager var2, ScaledResolution var3, float var4, float var5);

    public void onResize(Framebuffer buffer) {
    }

    public VisualPersistent createPersitentVisual() {
        return null;
    }

    public abstract boolean needsToBeRendered(float var1);
}

