/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.handlers;

import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;

public class SplashHandler
extends VisualHandler {
    public int splashMinDuration = 10;
    public int splashMaxDuration = 10;
    public float splashMinIntensity = 10.0f;
    public float splashMaxIntensity = 5.0f;
    public static int waterSubstractFactor = 10;
    public boolean wasInWater = false;

    public SplashHandler() {
        super("splash", "heart beat & splash blur effect");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.splashMinDuration = config.getInt("splashMinDuration", this.name, this.splashMinDuration, 0, 10000, "minimum splash duration");
        this.splashMaxDuration = config.getInt("splashMaxDuration", this.name, this.splashMaxDuration, 0, 10000, "maximum additional splash duration");
        this.splashMinIntensity = config.getFloat("splashMinIntensity", this.name, this.splashMinIntensity, 0.0f, 10000.0f, "minimum splash intensity");
        this.splashMaxIntensity = config.getFloat("splashMaxIntensity", this.name, this.splashMaxIntensity, 0.0f, 10000.0f, "maximum additional splash intensity");
        waterSubstractFactor = config.getInt("waterSubstractFactor", this.name, waterSubstractFactor, 0, 100000, "increased fade out factor in water");
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        if (player != null) {
            boolean isInWater = player.func_70055_a(Material.field_151586_h);
            if (isInWater != this.wasInWater) {
                VisualManager.addVisualWithShading(VisualType.blur, (float)((double)this.splashMinIntensity + Math.random() * (double)this.splashMaxIntensity), this.splashMinDuration, this.splashMaxDuration, Color.WHITE);
            }
            if (isInWater) {
                for (VisualCategory category : VisualManager.visuals.getKeys()) {
                    for (Visual visual : VisualManager.visuals.getValues(category)) {
                        if (!visual.type.isAffectedByWater) continue;
                        for (int i = 0; i < waterSubstractFactor; ++i) {
                            visual.onTick(player);
                        }
                    }
                }
            }
            this.wasInWater = isInWater;
        }
    }
}

