/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.events;

import com.sonicjumper.enhancedvisuals.EnhancedVisuals;
import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.death.DeathMessages;
import com.sonicjumper.enhancedvisuals.events.SoundMuteHandler;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.event.entity.ThrowableImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VisualEventHandler {
    private static Minecraft mc = Minecraft.func_71410_x();
    public static String lastRenderedMessage;
    private static int framebufferWidth;
    private static int framebufferHeight;

    public static boolean areEffectsEnabled() {
        return EnhancedVisuals.noEffectsForCreative ? VisualEventHandler.mc.field_71439_g != null && !VisualEventHandler.mc.field_71439_g.func_184812_l_() && !VisualEventHandler.mc.field_71439_g.func_175149_v() : true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && VisualEventHandler.areEffectsEnabled()) {
            if (!(VisualEventHandler.mc.field_71462_r instanceof GuiGameOver)) {
                lastRenderedMessage = null;
                if (VisualEventHandler.mc.field_71439_g == null) {
                    VisualEventHandler.onTickInGame(VisualEventHandler.mc.field_71439_g != null);
                }
                if (VisualEventHandler.mc.func_147110_a().field_147621_c != framebufferWidth || VisualEventHandler.mc.func_147110_a().field_147618_d != framebufferHeight) {
                    for (int i = 0; i < VisualCategory.shader.types.size(); ++i) {
                        VisualCategory.shader.types.get(i).onResize(mc.func_147110_a());
                    }
                    framebufferWidth = VisualEventHandler.mc.func_147110_a().field_147621_c;
                    framebufferHeight = VisualEventHandler.mc.func_147110_a().field_147618_d;
                }
                TextureManager manager = mc.func_110434_K();
                ScaledResolution resolution = new ScaledResolution(mc);
                float partialTicks = event.renderTickTime;
                GlStateManager.func_179086_m((int)256);
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179096_D();
                GlStateManager.func_179130_a((double)0.0, (double)resolution.func_78327_c(), (double)resolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179096_D();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179097_i();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179118_c();
                VisualEventHandler.renderVisuals(VisualManager.visuals.getValues(VisualCategory.splat), manager, resolution, partialTicks);
                VisualEventHandler.renderVisuals(VisualManager.visuals.getValues(VisualCategory.overlay), manager, resolution, partialTicks);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179096_D();
                VisualEventHandler.renderVisuals(VisualManager.visuals.getValues(VisualCategory.shader), manager, resolution, partialTicks);
                GlStateManager.func_179121_F();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179141_d();
                GlStateManager.func_179140_f();
                mc.func_147110_a().func_147610_a(false);
                GlStateManager.func_179128_n((int)5888);
            } else {
                if (VisualEventHandler.areEffectsEnabled()) {
                    VisualManager.resetAllVisuals();
                }
                if (DeathMessages.enabled) {
                    if (lastRenderedMessage == null) {
                        lastRenderedMessage = DeathMessages.pickRandomDeathMessage();
                    }
                    if (lastRenderedMessage != null) {
                        VisualEventHandler.mc.field_71466_p.func_78276_b("\"" + lastRenderedMessage + "\"", VisualEventHandler.mc.field_71462_r.field_146294_l / 2 - VisualEventHandler.mc.field_71466_p.func_78256_a(lastRenderedMessage) / 2, 114, 0xFFFFFF);
                    }
                }
            }
        }
    }

    private static void renderVisuals(List<Visual> visuals, TextureManager manager, ScaledResolution resolution, float partialTicks) {
        if (visuals == null || visuals.isEmpty()) {
            return;
        }
        for (Visual visual : visuals) {
            float intensity = visual.getIntensity() * visual.type.alpha;
            if (!visual.type.needsToBeRendered(intensity)) continue;
            GlStateManager.func_179094_E();
            visual.type.render(visual, manager, resolution, partialTicks, intensity);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && VisualEventHandler.areEffectsEnabled() && !(VisualEventHandler.mc.field_71462_r instanceof GuiGameOver)) {
            VisualEventHandler.onTickInGame(VisualEventHandler.mc.field_71439_g != null);
            SoundMuteHandler.tick();
        }
    }

    public static void onTickInGame(boolean isInGame) {
        VisualManager.onTick((EntityPlayer)VisualEventHandler.mc.field_71439_g);
        for (int i = 0; i < VisualHandler.activeHandlers.size(); ++i) {
            VisualHandler.activeHandlers.get(i).onTick((EntityPlayer)VisualEventHandler.mc.field_71439_g);
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingAttackEvent event) {
        block4: {
            block3: {
                if (!event.getEntityLiving().field_70170_p.field_72995_K || !VisualEventHandler.areEffectsEnabled()) {
                    return;
                }
                if (!(event.getEntity() instanceof EntityPlayer) || event.getEntity() != VisualEventHandler.mc.field_71439_g) break block3;
                for (int i = 0; i < VisualHandler.activeHandlers.size(); ++i) {
                    VisualHandler.activeHandlers.get(i).onPlayerDamaged((EntityPlayer)event.getEntity(), event.getSource(), event.getAmount());
                }
                break block4;
            }
            if (VisualEventHandler.mc.field_71439_g == null) break block4;
            double distance = Math.sqrt(VisualEventHandler.mc.field_71439_g.func_70068_e(event.getEntity()));
            for (int i = 0; i < VisualHandler.activeHandlers.size(); ++i) {
                VisualHandler.activeHandlers.get(i).onEntityDamaged(event.getEntityLiving(), event.getSource(), event.getAmount(), distance);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onSoundPlay(PlaySoundEvent event) {
        if (event.getSound().func_147650_b().equals((Object)SoundEvents.field_187539_bB.func_187503_a()) && VisualEventHandler.areEffectsEnabled()) {
            double distance = Math.sqrt(VisualEventHandler.mc.field_71439_g.func_70092_e((double)event.getSound().func_147649_g(), (double)event.getSound().func_147654_h(), (double)event.getSound().func_147651_i()));
            for (int i = 0; i < VisualHandler.activeHandlers.size(); ++i) {
                VisualHandler.activeHandlers.get(i).onExplosion((EntityPlayer)VisualEventHandler.mc.field_71439_g, event.getSound().func_147649_g(), event.getSound().func_147654_h(), event.getSound().func_147651_i(), distance);
            }
        }
    }

    @SubscribeEvent
    public static void onSoundPlayed(SoundEvent.SoundSourceEvent event) {
        if (SoundMuteHandler.isMuting && SoundMuteHandler.ignoredSounds != null && event.getSound().func_147650_b().toString().equals("enhancedvisuals:ringing")) {
            SoundMuteHandler.ignoredSounds.add(event.getUuid());
        }
    }

    @SubscribeEvent
    public static void onThrowableImpact(ThrowableImpactEvent event) {
        if (!VisualEventHandler.areEffectsEnabled()) {
            return;
        }
        for (int i = 0; i < VisualHandler.activeHandlers.size(); ++i) {
            VisualHandler.activeHandlers.get(i).onThrowableImpact(event);
        }
    }
}

