/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals.addon.toughasnails;

import com.sonicjumper.enhancedvisuals.VisualManager;
import com.sonicjumper.enhancedvisuals.addon.toughasnails.ToughAsNailsAddon;
import com.sonicjumper.enhancedvisuals.handlers.VisualHandler;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;
import toughasnails.api.TANCapabilities;
import toughasnails.api.stat.capability.IThirst;

public class ThirstHandler
extends VisualHandler {
    public float defaultIntensity = 0.0f;
    public float maxIntensity = 5.0f;
    public float fadeFactor = 0.05f;
    public int maxThirstLevelEffected = 8;
    public int minThirstLevelEffected = 2;

    public ThirstHandler() {
        super("thirst", "addon for ToughAsNailsAddon");
    }

    @Override
    public void initConfig(Configuration config) {
        super.initConfig(config);
        this.defaultIntensity = config.getFloat("defaultIntensity", this.name, this.defaultIntensity, 0.0f, 10000.0f, "the default/max thirst");
        this.maxIntensity = config.getFloat("maxIntensity", this.name, this.maxIntensity, 0.0f, 10000.0f, "lowest thirst");
        this.fadeFactor = config.getFloat("fadeFactor", this.name, this.fadeFactor, 0.0f, 10000.0f, "thirst += fadeFactor per Tick");
        this.maxThirstLevelEffected = config.getInt("maxThirstLevelEffected", this.name, this.maxThirstLevelEffected, 0, 20, "the maximum point thirst is effected");
        this.minThirstLevelEffected = config.getInt("minThirstLevelEffected", this.name, this.minThirstLevelEffected, 0, 20, "the minimum point thirst is effected");
    }

    @Override
    public void onTick(@Nullable EntityPlayer player) {
        VisualPersistent visual = VisualManager.getPersitentVisual(ToughAsNailsAddon.focus);
        if (visual != null) {
            float aimedSaturation = this.defaultIntensity;
            if (player != null && ((IThirst)player.getCapability(TANCapabilities.THIRST, null)).getThirst() <= this.maxThirstLevelEffected) {
                float leftFoodInSpan = ((IThirst)player.getCapability(TANCapabilities.THIRST, null)).getThirst() - this.minThirstLevelEffected;
                float spanLength = this.maxThirstLevelEffected - this.minThirstLevelEffected;
                aimedSaturation = (1.0f - leftFoodInSpan / spanLength) * this.maxIntensity;
            }
            if (visual.getIntensity() < aimedSaturation) {
                visual.setIntensity(Math.min(visual.getIntensity() + this.fadeFactor, aimedSaturation));
            } else if (visual.getIntensity() > aimedSaturation) {
                visual.setIntensity(Math.max(visual.getIntensity() - this.fadeFactor, aimedSaturation));
            }
        }
    }
}

