/*
 * Decompiled with CFR 0.152.
 */
package com.sonicjumper.enhancedvisuals;

import com.sonicjumper.enhancedvisuals.HashMapList;
import com.sonicjumper.enhancedvisuals.visuals.Visual;
import com.sonicjumper.enhancedvisuals.visuals.VisualFadeOut;
import com.sonicjumper.enhancedvisuals.visuals.VisualPersistent;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualCategory;
import com.sonicjumper.enhancedvisuals.visuals.types.VisualType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;

public class VisualManager {
    public static HashMapList<VisualCategory, Visual> visuals = new HashMapList();
    private static HashMap<VisualType, VisualPersistent> persistentVisuals = new HashMap();
    private static ArrayList<Visual> defaultVisuals = new ArrayList();

    public static VisualPersistent getPersitentVisual(VisualType type) {
        return persistentVisuals.get(type);
    }

    public static void addPersistentVisual(VisualPersistent visual) {
        if (!visual.type.isEnabled()) {
            return;
        }
        persistentVisuals.put(visual.type, visual);
        visuals.add(visual.type.category, visual);
    }

    public static void addVisual(Visual visual) {
        if (!visual.type.isEnabled()) {
            return;
        }
        VisualPersistent persitent = persistentVisuals.get(visual.type);
        if (persitent != null) {
            persitent.addVisual(visual);
        } else {
            defaultVisuals.add(visual);
            visuals.add(visual.type.category, visual);
        }
    }

    public static void addVisualsWithShading(VisualType vt, int num, int minTime, int maxTime) {
        VisualManager.addVisualsWithShading(vt, 1.0f, num, minTime, maxTime, Color.WHITE);
    }

    public static void addVisualWithShading(VisualType vt, float intensity, int minTime, int maxTime, Color color) {
        if (intensity <= 0.0f) {
            return;
        }
        VisualManager.addVisual(new VisualFadeOut(vt, intensity, minTime, maxTime, color));
    }

    public static void addVisualsWithShading(VisualType vt, float intensity, int num, int minTime, int maxTime, Color color) {
        if (intensity <= 0.0f) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            VisualManager.addVisualWithShading(vt, intensity, minTime, maxTime, color);
        }
    }

    public static void createVisualFromDamage(VisualType type, float damage, EntityLivingBase bleedingEntity) {
        VisualManager.createVisualFromDamageAndDistance(type, damage, bleedingEntity, 1.0);
    }

    public static void createVisualFromDamageAndDistance(VisualType type, float damage, EntityLivingBase bleedingEntity, double distanceSqToEntity) {
        if (damage <= 0.0f) {
            return;
        }
        double distance = Math.sqrt(distanceSqToEntity);
        distance = Math.max(distance, 1.0);
        double distMultiplier = 1.0 / (distance / 2.0);
        float rate = 0.0f;
        float health = bleedingEntity.func_110143_aJ() - damage;
        if (health > 12.0f) {
            rate = 1.0f;
        }
        if (health <= 12.0f && health > 8.0f) {
            rate = 1.5f;
        }
        if (health <= 8.0f && health > 4.0f) {
            rate = 2.0f;
        }
        if (health <= 4.0f && health > 0.0f) {
            rate = 2.5f;
        }
        if (health <= 0.0f) {
            rate = 3.0f;
        }
        int splats = (int)((double)(damage * rate) * distMultiplier);
        if (type.equals(VisualType.splatter) || type.equals(VisualType.slash) || type.equals(VisualType.pierce) || type.equals(VisualType.impact)) {
            if (bleedingEntity instanceof EntityCreeper) {
                VisualManager.addVisualsWithShading(type, 1.0f, splats, 500, 1500, new Color(0.0f, 0.4f, 0.0f, 0.7f));
            } else if (bleedingEntity instanceof EntitySkeleton) {
                VisualManager.addVisualsWithShading(type, 1.0f, splats, 500, 1500, new Color(0.1f, 0.1f, 0.1f, 0.7f));
            } else if (bleedingEntity instanceof EntitySquid) {
                VisualManager.addVisualsWithShading(type, 1.0f, splats, 500, 1500, new Color(0.0f, 0.0f, 0.2f, 0.7f));
            } else {
                VisualManager.addVisualsWithShading(type, 1.0f, splats, 500, 1500, new Color(0.3f, 0.01f, 0.01f, 0.7f));
            }
        } else if (type.equals(VisualType.dust)) {
            VisualManager.addVisualsWithShading(type, 1.0f, splats * 20, 100, 1000, new Color(0.2f, 0.2f, 0.2f, 1.0f));
        }
    }

    public static void resetAllVisuals() {
        for (VisualPersistent visualPersistent : persistentVisuals.values()) {
            visualPersistent.reset();
        }
        for (Visual visual : defaultVisuals) {
            visuals.removeValue(visual.type.category, visual);
        }
        defaultVisuals.clear();
    }

    public static void clearAllVisuals() {
        visuals.clear();
        persistentVisuals.clear();
        defaultVisuals.clear();
    }

    public static void onTick(@Nullable EntityPlayer player) {
        for (VisualPersistent visualPersistent : persistentVisuals.values()) {
            visualPersistent.onTick(player);
        }
        int i = 0;
        while (i < defaultVisuals.size()) {
            Visual visual = defaultVisuals.get(i);
            visual.onTick(player);
            if (visual.hasFinished()) {
                defaultVisuals.remove(i);
                visuals.removeValue(visual.type.category, visual);
                continue;
            }
            ++i;
        }
    }
}

