/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GeneratorBush
extends GeneratorTreeBase {
    public GeneratorBush(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, GeneratorUtils.ScatterYMethod scatterYMethod) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight, scatterYMethod);
    }

    public boolean func_180709_b(World world, Random random, BlockPos startPos) {
        while (startPos.func_177956_o() > 1 && world.func_175623_d(startPos) || world.func_180495_p(startPos).func_177230_c().isLeaves(world.func_180495_p(startPos), (IBlockAccess)world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        int height = GeneratorUtils.nextIntBetween(random, this.minHeight, this.maxHeight);
        BlockPos pos = startPos.func_177984_a();
        for (int y = 0; y < height; ++y) {
            if (height - y > 1) {
                this.setLog(world, pos.func_177982_a(0, y, 0));
            }
            int leavesRadius = height - y > 1 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius && random.nextInt(2) == 0) continue;
                    if (this.altLeaves != null) {
                        if (random.nextInt(4) == 0) {
                            this.setAltLeaves(world, pos.func_177982_a(x, y, z));
                            continue;
                        }
                        this.setLeaves(world, pos.func_177982_a(x, y, z));
                        continue;
                    }
                    this.setLeaves(world, pos.func_177982_a(x, y, z));
                }
            }
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorBush>
    implements IGenerator.IGeneratorBuilder<GeneratorBush> {
        public Builder() {
            this.amountPerChunk = 1.0f;
            this.minHeight = 2;
            this.maxHeight = 4;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.replaceable;
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P();
            this.vine = null;
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
        }

        @Override
        public GeneratorBush create() {
            return new GeneratorBush(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, this.scatterYMethod);
        }
    }
}

