/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.init;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.block.BlockBOPFence;
import biomesoplenty.common.block.BlockBOPFenceGate;
import biomesoplenty.common.block.BlockBOPFlower;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.BlockBOPHalfWoodSlab;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.block.BlockBOPPlanks;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.block.BlockBOPSapling;
import biomesoplenty.common.block.BlockBOPWoodStairs;
import biomesoplenty.common.handler.FurnaceFuelHandler;
import com.google.common.base.CaseFormat;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ModCrafting {
    public static void init() {
        ModCrafting.addOreRegistration();
        ModCrafting.addSmeltingRecipes();
    }

    private static void addSmeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)new ItemStack(BOPBlocks.mud), (ItemStack)new ItemStack(Blocks.field_150346_d), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(BOPBlocks.white_sand), (ItemStack)new ItemStack(Blocks.field_150359_w), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)BlockBOPPlant.paging.getVariantItem(BOPPlants.TINYCACTUS), (ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.GREEN.func_176767_b()), (float)0.2f);
        GameRegistry.addSmelting((Item)BOPItems.mudball, (ItemStack)new ItemStack(BOPItems.mud_brick), (float)0.1f);
        for (BOPWoods wood : BOPWoods.values()) {
            if (!wood.canMakeCharcoal()) continue;
            GameRegistry.addSmelting((ItemStack)BlockBOPLog.paging.getVariantItem(wood), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        FurnaceFuelHandler bopFuel = new FurnaceFuelHandler();
        GameRegistry.registerFuelHandler((IFuelHandler)bopFuel);
        bopFuel.addFuel(BOPBlocks.sapling_0, 100);
        bopFuel.addFuel(BOPBlocks.sapling_1, 100);
        bopFuel.addFuel(BOPBlocks.sapling_2, 100);
        bopFuel.addFuel(BOPBlocks.wood_slab_0, 150);
        bopFuel.addFuel(BOPBlocks.wood_slab_1, 150);
        bopFuel.addFuel(BOPItems.ash, 400);
    }

    private static void addOreRegistration() {
        OreDictionary.registerOre((String)"stickWood", (ItemStack)new ItemStack(BOPBlocks.bamboo));
        OreDictionary.registerOre((String)"stickWood", (ItemStack)BlockBOPPlant.paging.getVariantItem(BOPPlants.RIVERCANE));
        OreDictionary.registerOre((String)"ballMud", (ItemStack)new ItemStack(BOPItems.mudball));
        OreDictionary.registerOre((String)"blockMeatRaw", (ItemStack)new ItemStack(BOPBlocks.flesh, 1, 0));
        OreDictionary.registerOre((String)"grass", (ItemStack)new ItemStack(BOPBlocks.grass, 1, BlockBOPGrass.BOPGrassType.LOAMY.ordinal()));
        OreDictionary.registerOre((String)"grass", (ItemStack)new ItemStack(BOPBlocks.grass, 1, BlockBOPGrass.BOPGrassType.SILTY.ordinal()));
        OreDictionary.registerOre((String)"grass", (ItemStack)new ItemStack(BOPBlocks.grass, 1, BlockBOPGrass.BOPGrassType.SANDY.ordinal()));
        OreDictionary.registerOre((String)"grass", (ItemStack)new ItemStack(BOPBlocks.grass, 1, BlockBOPGrass.BOPGrassType.DAISY.ordinal()));
        OreDictionary.registerOre((String)"grass", (ItemStack)new ItemStack(BOPBlocks.grass, 1, BlockBOPGrass.BOPGrassType.ORIGIN.ordinal()));
        OreDictionary.registerOre((String)"dirt", (ItemStack)new ItemStack(BOPBlocks.dirt, 1, BlockBOPDirt.BOPDirtType.LOAMY.ordinal()));
        OreDictionary.registerOre((String)"dirt", (ItemStack)new ItemStack(BOPBlocks.dirt, 1, BlockBOPDirt.BOPDirtType.SILTY.ordinal()));
        OreDictionary.registerOre((String)"dirt", (ItemStack)new ItemStack(BOPBlocks.dirt, 1, BlockBOPDirt.BOPDirtType.SANDY.ordinal()));
        OreDictionary.registerOre((String)"blockMud", (ItemStack)new ItemStack(BOPBlocks.mud));
        OreDictionary.registerOre((String)"sand", (ItemStack)new ItemStack(BOPBlocks.white_sand));
        OreDictionary.registerOre((String)"sandstone", (ItemStack)new ItemStack(BOPBlocks.white_sandstone));
        OreDictionary.registerOre((String)"foodMushroompowder", (ItemStack)new ItemStack(BOPItems.shroompowder));
        OreDictionary.registerOre((String)"foodFruitsalad", (ItemStack)new ItemStack(BOPItems.saladfruit));
        OreDictionary.registerOre((String)"foodVeggiesalad", (ItemStack)new ItemStack(BOPItems.saladveggie));
        OreDictionary.registerOre((String)"foodMushroomsalad", (ItemStack)new ItemStack(BOPItems.saladshroom));
        OreDictionary.registerOre((String)"foodFilledhoneycomb", (ItemStack)new ItemStack(BOPItems.filled_honeycomb));
        OreDictionary.registerOre((String)"foodAmbrosia", (ItemStack)new ItemStack(BOPItems.ambrosia));
        OreDictionary.registerOre((String)"foodBowlofrice", (ItemStack)new ItemStack(BOPItems.ricebowl));
        OreDictionary.registerOre((String)"cropPeach", (ItemStack)new ItemStack(BOPItems.peach));
        OreDictionary.registerOre((String)"cropPersimmon", (ItemStack)new ItemStack(BOPItems.persimmon));
        OreDictionary.registerOre((String)"cropTurnip", (ItemStack)new ItemStack(BOPItems.turnip));
        OreDictionary.registerOre((String)"cropPear", (ItemStack)new ItemStack(BOPItems.pear));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack(BOPItems.peach));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack(BOPItems.persimmon));
        OreDictionary.registerOre((String)"listAllrootveggie", (ItemStack)new ItemStack(BOPItems.turnip));
        OreDictionary.registerOre((String)"listAllveggie", (ItemStack)new ItemStack(BOPItems.turnip));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack(BOPItems.pear));
        OreDictionary.registerOre((String)"seedTurnip", (ItemStack)new ItemStack(BOPItems.turnip_seeds));
        OreDictionary.registerOre((String)"listAllseed", (ItemStack)new ItemStack(BOPItems.turnip_seeds));
        OreDictionary.registerOre((String)"dyeBlue", (ItemStack)new ItemStack(BOPItems.blue_dye));
        OreDictionary.registerOre((String)"dyeBrown", (ItemStack)new ItemStack(BOPItems.brown_dye));
        OreDictionary.registerOre((String)"dyeGreen", (ItemStack)new ItemStack(BOPItems.green_dye));
        OreDictionary.registerOre((String)"dyeWhite", (ItemStack)new ItemStack(BOPItems.white_dye));
        OreDictionary.registerOre((String)"dyeBlack", (ItemStack)new ItemStack(BOPItems.black_dye));
        OreDictionary.registerOre((String)"record", (ItemStack)new ItemStack(BOPItems.record_wanderer));
        for (BOPGems bOPGems : BOPGems.values()) {
            String gemName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, bOPGems.name());
            OreDictionary.registerOre((String)("gem" + gemName), (ItemStack)new ItemStack(BOPItems.gem, 1, bOPGems.ordinal()));
            OreDictionary.registerOre((String)("ore" + gemName), (ItemStack)new ItemStack(BOPBlocks.gem_ore, 1, bOPGems.ordinal()));
        }
        for (Enum enum_ : BOPFlowers.values()) {
            String flowerName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enum_.name());
            OreDictionary.registerOre((String)("flower" + flowerName), (ItemStack)BlockBOPFlower.paging.getVariantItem((BOPFlowers)enum_));
        }
        for (Enum enum_ : BOPPlants.values()) {
            String plantName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enum_.name());
            OreDictionary.registerOre((String)("plant" + plantName), (ItemStack)BlockBOPPlant.paging.getVariantItem((BOPPlants)enum_));
        }
        OreDictionary.registerOre((String)"plantFlax", (ItemStack)((BlockBOPDoublePlant)BOPBlocks.double_plant).getVariantItem(BlockBOPDoublePlant.DoublePlantType.FLAX));
        OreDictionary.registerOre((String)"plantCattail", (ItemStack)((BlockBOPDoublePlant)BOPBlocks.double_plant).getVariantItem(BlockBOPDoublePlant.DoublePlantType.TALL_CATTAIL));
        for (Enum enum_ : BOPTrees.values()) {
            OreDictionary.registerOre((String)"treeLeaves", (ItemStack)BlockBOPLeaves.paging.getVariantItem((BOPTrees)enum_));
            if (!((BOPTrees)enum_).hasSapling()) continue;
            OreDictionary.registerOre((String)"treeSapling", (ItemStack)BlockBOPSapling.paging.getVariantItem((BOPTrees)enum_));
        }
        for (Enum enum_ : BOPWoods.values()) {
            OreDictionary.registerOre((String)"logWood", (ItemStack)BlockBOPLog.paging.getVariantItem((BOPWoods)enum_));
            if (!((BOPWoods)enum_).hasPlanks()) continue;
            OreDictionary.registerOre((String)"plankWood", (ItemStack)BlockBOPPlanks.paging.getVariantItem((BOPWoods)enum_));
            OreDictionary.registerOre((String)"slabWood", (ItemStack)BlockBOPHalfWoodSlab.paging.getVariantItem((BOPWoods)enum_));
            OreDictionary.registerOre((String)"stairWood", (ItemStack)new ItemStack((Block)BlockBOPWoodStairs.getBlock((BOPWoods)enum_)));
            OreDictionary.registerOre((String)"fenceWood", (ItemStack)new ItemStack((Block)BlockBOPFence.getBlock((BOPWoods)enum_)));
            OreDictionary.registerOre((String)"fenceGateWood", (ItemStack)new ItemStack((Block)BlockBOPFenceGate.getBlock((BOPWoods)enum_)));
        }
    }
}

