/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.biome.nether.BOPHellBiome;
import biomesoplenty.common.biome.nether.BiomeCorruptedSands;
import biomesoplenty.common.biome.nether.BiomeFungiForest;
import biomesoplenty.common.biome.nether.BiomePhantasmagoricInferno;
import biomesoplenty.common.biome.nether.BiomePolarChasm;
import biomesoplenty.common.biome.nether.BiomeUndergarden;
import biomesoplenty.common.biome.nether.BiomeVisceralHeap;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.biome.overworld.BiomeGenAlps;
import biomesoplenty.common.biome.overworld.BiomeGenBambooForest;
import biomesoplenty.common.biome.overworld.BiomeGenBayou;
import biomesoplenty.common.biome.overworld.BiomeGenBog;
import biomesoplenty.common.biome.overworld.BiomeGenBorealForest;
import biomesoplenty.common.biome.overworld.BiomeGenBrushland;
import biomesoplenty.common.biome.overworld.BiomeGenChaparral;
import biomesoplenty.common.biome.overworld.BiomeGenCherryBlossomGrove;
import biomesoplenty.common.biome.overworld.BiomeGenColdDesert;
import biomesoplenty.common.biome.overworld.BiomeGenConiferousForest;
import biomesoplenty.common.biome.overworld.BiomeGenCoralReef;
import biomesoplenty.common.biome.overworld.BiomeGenCrag;
import biomesoplenty.common.biome.overworld.BiomeGenDeadForest;
import biomesoplenty.common.biome.overworld.BiomeGenDeadSwamp;
import biomesoplenty.common.biome.overworld.BiomeGenEucalyptusForest;
import biomesoplenty.common.biome.overworld.BiomeGenFen;
import biomesoplenty.common.biome.overworld.BiomeGenFlowerField;
import biomesoplenty.common.biome.overworld.BiomeGenFlowerIsland;
import biomesoplenty.common.biome.overworld.BiomeGenGlacier;
import biomesoplenty.common.biome.overworld.BiomeGenGrassland;
import biomesoplenty.common.biome.overworld.BiomeGenGravelBeach;
import biomesoplenty.common.biome.overworld.BiomeGenGrove;
import biomesoplenty.common.biome.overworld.BiomeGenHighland;
import biomesoplenty.common.biome.overworld.BiomeGenKelpForest;
import biomesoplenty.common.biome.overworld.BiomeGenLandOfLakes;
import biomesoplenty.common.biome.overworld.BiomeGenLavenderFields;
import biomesoplenty.common.biome.overworld.BiomeGenLushDesert;
import biomesoplenty.common.biome.overworld.BiomeGenLushSwamp;
import biomesoplenty.common.biome.overworld.BiomeGenMangrove;
import biomesoplenty.common.biome.overworld.BiomeGenMapleWoods;
import biomesoplenty.common.biome.overworld.BiomeGenMarsh;
import biomesoplenty.common.biome.overworld.BiomeGenMeadow;
import biomesoplenty.common.biome.overworld.BiomeGenMoor;
import biomesoplenty.common.biome.overworld.BiomeGenMountain;
import biomesoplenty.common.biome.overworld.BiomeGenMysticGrove;
import biomesoplenty.common.biome.overworld.BiomeGenOasis;
import biomesoplenty.common.biome.overworld.BiomeGenOminousWoods;
import biomesoplenty.common.biome.overworld.BiomeGenOrchard;
import biomesoplenty.common.biome.overworld.BiomeGenOriginIsland;
import biomesoplenty.common.biome.overworld.BiomeGenOutback;
import biomesoplenty.common.biome.overworld.BiomeGenOvergrownCliffs;
import biomesoplenty.common.biome.overworld.BiomeGenPrairie;
import biomesoplenty.common.biome.overworld.BiomeGenQuagmire;
import biomesoplenty.common.biome.overworld.BiomeGenRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenRedwoodForest;
import biomesoplenty.common.biome.overworld.BiomeGenSacredSprings;
import biomesoplenty.common.biome.overworld.BiomeGenSeasonalForest;
import biomesoplenty.common.biome.overworld.BiomeGenShield;
import biomesoplenty.common.biome.overworld.BiomeGenShrubland;
import biomesoplenty.common.biome.overworld.BiomeGenSnowyConiferousForest;
import biomesoplenty.common.biome.overworld.BiomeGenSnowyForest;
import biomesoplenty.common.biome.overworld.BiomeGenSteppe;
import biomesoplenty.common.biome.overworld.BiomeGenTemperateRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenTropicalIsland;
import biomesoplenty.common.biome.overworld.BiomeGenTropicalRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenTundra;
import biomesoplenty.common.biome.overworld.BiomeGenVolcanicIsland;
import biomesoplenty.common.biome.overworld.BiomeGenWasteland;
import biomesoplenty.common.biome.overworld.BiomeGenWetland;
import biomesoplenty.common.biome.overworld.BiomeGenWhiteBeach;
import biomesoplenty.common.biome.overworld.BiomeGenWoodland;
import biomesoplenty.common.biome.overworld.BiomeGenXericShrubland;
import biomesoplenty.common.biome.vanilla.BiomeExtBirchForest;
import biomesoplenty.common.biome.vanilla.BiomeExtBirchForestHills;
import biomesoplenty.common.biome.vanilla.BiomeExtColdTaiga;
import biomesoplenty.common.biome.vanilla.BiomeExtColdTaigaHills;
import biomesoplenty.common.biome.vanilla.BiomeExtDesert;
import biomesoplenty.common.biome.vanilla.BiomeExtDesertHills;
import biomesoplenty.common.biome.vanilla.BiomeExtEnd;
import biomesoplenty.common.biome.vanilla.BiomeExtExtremeHills;
import biomesoplenty.common.biome.vanilla.BiomeExtExtremeHillsPlus;
import biomesoplenty.common.biome.vanilla.BiomeExtForest;
import biomesoplenty.common.biome.vanilla.BiomeExtForestHills;
import biomesoplenty.common.biome.vanilla.BiomeExtHell;
import biomesoplenty.common.biome.vanilla.BiomeExtIceMountains;
import biomesoplenty.common.biome.vanilla.BiomeExtIcePlains;
import biomesoplenty.common.biome.vanilla.BiomeExtJungle;
import biomesoplenty.common.biome.vanilla.BiomeExtJungleHills;
import biomesoplenty.common.biome.vanilla.BiomeExtMegaTaiga;
import biomesoplenty.common.biome.vanilla.BiomeExtMegaTaigaHills;
import biomesoplenty.common.biome.vanilla.BiomeExtMesa;
import biomesoplenty.common.biome.vanilla.BiomeExtMesaPlateau;
import biomesoplenty.common.biome.vanilla.BiomeExtMushroomIsland;
import biomesoplenty.common.biome.vanilla.BiomeExtOcean;
import biomesoplenty.common.biome.vanilla.BiomeExtPlains;
import biomesoplenty.common.biome.vanilla.BiomeExtRoofedForest;
import biomesoplenty.common.biome.vanilla.BiomeExtSavanna;
import biomesoplenty.common.biome.vanilla.BiomeExtSavannaPlateau;
import biomesoplenty.common.biome.vanilla.BiomeExtSwampland;
import biomesoplenty.common.biome.vanilla.BiomeExtTaiga;
import biomesoplenty.common.biome.vanilla.BiomeExtTaigaHills;
import biomesoplenty.common.command.BOPCommand;
import biomesoplenty.common.util.config.BOPConfig;
import biomesoplenty.common.world.WorldProviderBOPHell;
import biomesoplenty.common.world.WorldTypeBOP;
import biomesoplenty.core.BiomesOPlenty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Biomes;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FileUtils;

public class ModBiomes
implements BOPBiomes.IBiomeRegistry {
    public static final File BIOMES_DIR = new File(BiomesOPlenty.configDirectory, "biomes");
    public static final File DEFAULTS_DIR = new File(BIOMES_DIR, "defaults");
    public static final File BOP_DEFAULTS_DIR = new File(DEFAULTS_DIR, "biomesoplenty");
    public static final File VANILLA_DEFAULTS_DIR = new File(DEFAULTS_DIR, "vanilla");
    public static WorldTypeBOP worldTypeBOP;
    private static int nextBiomeId;
    private static File biomeIdMapFile;
    private static IConfigObj biomeIdMapConf;
    protected static Map<String, Integer> biomeIdMap;
    private static Set<Integer> idsReservedInConfig;
    private static Map<Integer, IExtendedBiome> biomeWrapperMap;
    public static Set<Biome> presentBiomes;
    public static Map<Integer, List<Integer>> subBiomesMap;
    public static Map<Integer, Integer> islandBiomesMap;
    public static int totalIslandBiomesWeight;

    public static void init() {
        worldTypeBOP = new WorldTypeBOP();
        biomeIdMapFile = new File(BiomesOPlenty.configDirectory, "biome_ids.json");
        biomeIdMapConf = new BOPConfig.ConfigFileObj(biomeIdMapFile);
        biomeIdMap = new HashMap<String, Integer>();
        presentBiomes = Sets.newHashSet();
        idsReservedInConfig = new HashSet<Integer>();
        for (String biomeIdName : biomeIdMapConf.getKeys()) {
            Integer reservedId = biomeIdMapConf.getInt(biomeIdName);
            if (reservedId == null || reservedId <= -1) continue;
            idsReservedInConfig.add(reservedId);
        }
        if (!BIOMES_DIR.exists()) {
            BIOMES_DIR.mkdir();
            try {
                new File(BIOMES_DIR, "Put biome config files here").createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            FileUtils.deleteDirectory((File)DEFAULTS_DIR);
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("Could not delete default biome config directory!");
        }
        DEFAULTS_DIR.mkdir();
        ModBiomes.initSubBiomes();
        ModBiomes.registerBiomes();
        ModBiomes.registerBiomeDictionaryTags();
        ModBiomes.initExtendedBiomes();
        ModBiomes.registerNetherOverride();
        BOPConfig.writeFile(biomeIdMapFile, biomeIdMap);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_151360_e);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_180271_f);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_77137_b);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_77136_e);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_77138_c);
        BOPBiomes.excludedDecoratedWorldTypes.add(WorldType.field_77135_d);
    }

    public static void initSubBiomes() {
        subBiomesMap = new HashMap<Integer, List<Integer>>();
        ModBiomes.setSubBiome(Biomes.field_76769_d, Biomes.field_76786_s);
        ModBiomes.setSubBiome(Biomes.field_76767_f, Biomes.field_76785_t);
        ModBiomes.setSubBiome(Biomes.field_150583_P, Biomes.field_150582_Q);
        ModBiomes.setSubBiome(Biomes.field_150585_R, Biomes.field_76772_c);
        ModBiomes.setSubBiome(Biomes.field_76768_g, Biomes.field_76784_u);
        ModBiomes.setSubBiome(Biomes.field_150578_U, Biomes.field_150581_V);
        ModBiomes.setSubBiome(Biomes.field_150584_S, Biomes.field_150579_T);
        ModBiomes.setSubBiome(Biomes.field_76772_c, Biomes.field_76785_t, Biomes.field_76767_f);
        ModBiomes.setSubBiome(Biomes.field_76774_n, Biomes.field_76775_o);
        ModBiomes.setSubBiome(Biomes.field_76782_w, Biomes.field_76792_x);
        ModBiomes.setSubBiome(Biomes.field_76770_e, Biomes.field_150580_W);
        ModBiomes.setSubBiome(Biomes.field_150588_X, Biomes.field_150587_Y);
        ModBiomes.setSubBiome(Biomes.field_150607_aa, Biomes.field_150589_Z);
        ModBiomes.setSubBiome(Biomes.field_76771_b, Biomes.field_150575_M);
    }

    private static void registerBiomes() {
        BOPBiomes.gravel_beach = ModBiomes.registerOverworldBiome(new BiomeGenGravelBeach());
        BOPBiomes.white_beach = ModBiomes.registerOverworldBiome(new BiomeGenWhiteBeach());
        BOPBiomes.alps = ModBiomes.registerOverworldBiome(new BiomeGenAlps(BiomeGenAlps.AlpsType.ALPS));
        BOPBiomes.bamboo_forest = ModBiomes.registerOverworldBiome(new BiomeGenBambooForest());
        BOPBiomes.bayou = ModBiomes.registerOverworldBiome(new BiomeGenBayou());
        BOPBiomes.bog = ModBiomes.registerOverworldBiome(new BiomeGenBog());
        BOPBiomes.boreal_forest = ModBiomes.registerOverworldBiome(new BiomeGenBorealForest());
        BOPBiomes.brushland = ModBiomes.registerOverworldBiome(new BiomeGenBrushland());
        BOPBiomes.chaparral = ModBiomes.registerOverworldBiome(new BiomeGenChaparral());
        BOPBiomes.cherry_blossom_grove = ModBiomes.registerOverworldBiome(new BiomeGenCherryBlossomGrove());
        BOPBiomes.cold_desert = ModBiomes.registerOverworldBiome(new BiomeGenColdDesert());
        BOPBiomes.coniferous_forest = ModBiomes.registerOverworldBiome(new BiomeGenConiferousForest());
        BOPBiomes.crag = ModBiomes.registerOverworldBiome(new BiomeGenCrag());
        BOPBiomes.dead_forest = ModBiomes.registerOverworldBiome(new BiomeGenDeadForest());
        BOPBiomes.dead_swamp = ModBiomes.registerOverworldBiome(new BiomeGenDeadSwamp());
        BOPBiomes.eucalyptus_forest = ModBiomes.registerOverworldBiome(new BiomeGenEucalyptusForest());
        BOPBiomes.fen = ModBiomes.registerOverworldBiome(new BiomeGenFen());
        BOPBiomes.flower_field = ModBiomes.registerOverworldBiome(new BiomeGenFlowerField());
        BOPBiomes.grassland = ModBiomes.registerOverworldBiome(new BiomeGenGrassland());
        BOPBiomes.grove = ModBiomes.registerOverworldBiome(new BiomeGenGrove());
        BOPBiomes.highland = ModBiomes.registerOverworldBiome(new BiomeGenHighland());
        BOPBiomes.land_of_lakes = ModBiomes.registerOverworldBiome(new BiomeGenLandOfLakes());
        BOPBiomes.lavender_fields = ModBiomes.registerOverworldBiome(new BiomeGenLavenderFields());
        BOPBiomes.lush_desert = ModBiomes.registerOverworldBiome(new BiomeGenLushDesert());
        BOPBiomes.lush_swamp = ModBiomes.registerOverworldBiome(new BiomeGenLushSwamp());
        BOPBiomes.mangrove = ModBiomes.registerOverworldBiome(new BiomeGenMangrove());
        BOPBiomes.maple_woods = ModBiomes.registerOverworldBiome(new BiomeGenMapleWoods());
        BOPBiomes.marsh = ModBiomes.registerOverworldBiome(new BiomeGenMarsh());
        BOPBiomes.meadow = ModBiomes.registerOverworldBiome(new BiomeGenMeadow());
        BOPBiomes.moor = ModBiomes.registerOverworldBiome(new BiomeGenMoor());
        BOPBiomes.mountain = ModBiomes.registerOverworldBiome(new BiomeGenMountain(BiomeGenMountain.MountainType.MOUNTAIN));
        BOPBiomes.mystic_grove = ModBiomes.registerOverworldBiome(new BiomeGenMysticGrove());
        BOPBiomes.ominous_woods = ModBiomes.registerOverworldBiome(new BiomeGenOminousWoods());
        BOPBiomes.orchard = ModBiomes.registerOverworldBiome(new BiomeGenOrchard());
        BOPBiomes.outback = ModBiomes.registerOverworldBiome(new BiomeGenOutback());
        BOPBiomes.overgrown_cliffs = ModBiomes.registerOverworldBiome(new BiomeGenOvergrownCliffs());
        BOPBiomes.prairie = ModBiomes.registerOverworldBiome(new BiomeGenPrairie());
        BOPBiomes.quagmire = ModBiomes.registerOverworldBiome(new BiomeGenQuagmire());
        BOPBiomes.rainforest = ModBiomes.registerOverworldBiome(new BiomeGenRainforest());
        BOPBiomes.redwood_forest = ModBiomes.registerOverworldBiome(new BiomeGenRedwoodForest());
        BOPBiomes.sacred_springs = ModBiomes.registerOverworldBiome(new BiomeGenSacredSprings());
        BOPBiomes.seasonal_forest = ModBiomes.registerOverworldBiome(new BiomeGenSeasonalForest());
        BOPBiomes.shield = ModBiomes.registerOverworldBiome(new BiomeGenShield());
        BOPBiomes.shrubland = ModBiomes.registerOverworldBiome(new BiomeGenShrubland());
        BOPBiomes.snowy_coniferous_forest = ModBiomes.registerOverworldBiome(new BiomeGenSnowyConiferousForest());
        BOPBiomes.snowy_forest = ModBiomes.registerOverworldBiome(new BiomeGenSnowyForest());
        BOPBiomes.steppe = ModBiomes.registerOverworldBiome(new BiomeGenSteppe());
        BOPBiomes.temperate_rainforest = ModBiomes.registerOverworldBiome(new BiomeGenTemperateRainforest());
        BOPBiomes.tropical_rainforest = ModBiomes.registerOverworldBiome(new BiomeGenTropicalRainforest());
        BOPBiomes.tundra = ModBiomes.registerOverworldBiome(new BiomeGenTundra());
        BOPBiomes.wasteland = ModBiomes.registerOverworldBiome(new BiomeGenWasteland());
        BOPBiomes.wetland = ModBiomes.registerOverworldBiome(new BiomeGenWetland());
        BOPBiomes.woodland = ModBiomes.registerOverworldBiome(new BiomeGenWoodland());
        BOPBiomes.xeric_shrubland = ModBiomes.registerOverworldBiome(new BiomeGenXericShrubland());
        BOPBiomes.alps_foothills = ModBiomes.registerOverworldBiome(new BiomeGenAlps(BiomeGenAlps.AlpsType.ALPS_FOOTHILLS));
        BOPBiomes.mountain_foothills = ModBiomes.registerOverworldBiome(new BiomeGenMountain(BiomeGenMountain.MountainType.MOUNTAIN_FOOTHILLS));
        BOPBiomes.glacier = ModBiomes.registerOverworldBiome(new BiomeGenGlacier());
        BOPBiomes.oasis = ModBiomes.registerOverworldBiome(new BiomeGenOasis());
        BOPBiomes.coral_reef = ModBiomes.registerOverworldBiome(new BiomeGenCoralReef());
        BOPBiomes.kelp_forest = ModBiomes.registerOverworldBiome(new BiomeGenKelpForest());
        ModBiomes.setSubBiome((Optional<Biome>)Optional.of((Object)Biomes.field_76774_n), BOPBiomes.glacier);
        ModBiomes.setSubBiome((Optional<Biome>)Optional.of((Object)Biomes.field_76769_d), BOPBiomes.oasis);
        ModBiomes.setSubBiome((Optional<Biome>)Optional.of((Object)Biomes.field_76771_b), BOPBiomes.coral_reef);
        ModBiomes.setSubBiome((Optional<Biome>)Optional.of((Object)Biomes.field_76771_b), BOPBiomes.kelp_forest);
        BOPBiomes.origin_island = ModBiomes.registerOverworldBiome(new BiomeGenOriginIsland());
        BOPBiomes.tropical_island = ModBiomes.registerOverworldBiome(new BiomeGenTropicalIsland());
        BOPBiomes.volcanic_island = ModBiomes.registerOverworldBiome(new BiomeGenVolcanicIsland());
        BOPBiomes.flower_island = ModBiomes.registerOverworldBiome(new BiomeGenFlowerIsland());
        ModBiomes.addIslandBiome(BOPBiomes.origin_island, 1);
        ModBiomes.addIslandBiome(BOPBiomes.tropical_island, 3);
        ModBiomes.addIslandBiome(BOPBiomes.volcanic_island, 5);
        ModBiomes.addIslandBiome(BOPBiomes.flower_island, 7);
        BOPBiomes.corrupted_sands = ModBiomes.registerNetherBiome(new BiomeCorruptedSands());
        BOPBiomes.fungi_forest = ModBiomes.registerNetherBiome(new BiomeFungiForest());
        BOPBiomes.phantasmagoric_inferno = ModBiomes.registerNetherBiome(new BiomePhantasmagoricInferno());
        BOPBiomes.polar_chasm = ModBiomes.registerNetherBiome(new BiomePolarChasm());
        BOPBiomes.undergarden = ModBiomes.registerNetherBiome(new BiomeUndergarden());
        BOPBiomes.visceral_heap = ModBiomes.registerNetherBiome(new BiomeVisceralHeap());
    }

    public static void initExtendedBiomes() {
        biomeWrapperMap = new HashMap<Integer, IExtendedBiome>();
        BOPBiomes.end_extension = ModBiomes.registerWrappedBiome(new BiomeExtEnd(), "end");
        BOPBiomes.mushroom_island_extension = ModBiomes.registerWrappedBiome(new BiomeExtMushroomIsland(), "mushroom_island");
        BOPBiomes.birch_forest_extension = ModBiomes.registerWrappedBiome(new BiomeExtBirchForest(), "birch_forest");
        BOPBiomes.birch_forest_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtBirchForestHills(), "birch_forest_hills");
        BOPBiomes.cold_taiga_extension = ModBiomes.registerWrappedBiome(new BiomeExtColdTaiga(), "cold_taiga");
        BOPBiomes.cold_taiga_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtColdTaigaHills(), "cold_taiga_hills");
        BOPBiomes.desert_extension = ModBiomes.registerWrappedBiome(new BiomeExtDesert(), "desert");
        BOPBiomes.desert_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtDesertHills(), "desert_hills");
        BOPBiomes.extreme_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtExtremeHills(), "extreme_hills");
        BOPBiomes.extreme_hills_plus_extension = ModBiomes.registerWrappedBiome(new BiomeExtExtremeHillsPlus(), "extreme_hills+");
        BOPBiomes.forest_extension = ModBiomes.registerWrappedBiome(new BiomeExtForest(), "forest");
        BOPBiomes.forest_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtForestHills(), "forest_hills");
        BOPBiomes.ice_plains_extension = ModBiomes.registerWrappedBiome(new BiomeExtIcePlains(), "ice_plains");
        BOPBiomes.ice_mountains_extension = ModBiomes.registerWrappedBiome(new BiomeExtIceMountains(), "ice_mountains");
        BOPBiomes.jungle_extension = ModBiomes.registerWrappedBiome(new BiomeExtJungle(), "jungle");
        BOPBiomes.jungle_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtJungleHills(), "jungle_hills");
        BOPBiomes.mega_taiga_extension = ModBiomes.registerWrappedBiome(new BiomeExtMegaTaiga(), "mega_taiga");
        BOPBiomes.mega_taiga_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtMegaTaigaHills(), "mega_taiga_hills");
        BOPBiomes.mesa_extension = ModBiomes.registerWrappedBiome(new BiomeExtMesa(), "mesa");
        BOPBiomes.mesa_plateau_extension = ModBiomes.registerWrappedBiome(new BiomeExtMesaPlateau(), "mesa_plateau");
        BOPBiomes.ocean_extension = ModBiomes.registerWrappedBiome(new BiomeExtOcean(), "ocean");
        BOPBiomes.plains_extension = ModBiomes.registerWrappedBiome(new BiomeExtPlains(), "plains");
        BOPBiomes.roofed_forest_extension = ModBiomes.registerWrappedBiome(new BiomeExtRoofedForest(), "roofed_forest");
        BOPBiomes.savanna_extension = ModBiomes.registerWrappedBiome(new BiomeExtSavanna(), "savanna");
        BOPBiomes.savanna_plateau_extension = ModBiomes.registerWrappedBiome(new BiomeExtSavannaPlateau(), "savanna_plateau");
        BOPBiomes.swampland_extension = ModBiomes.registerWrappedBiome(new BiomeExtSwampland(), "swampland");
        BOPBiomes.taiga_extension = ModBiomes.registerWrappedBiome(new BiomeExtTaiga(), "taiga");
        BOPBiomes.taiga_hills_extension = ModBiomes.registerWrappedBiome(new BiomeExtTaigaHills(), "taiga_hills");
        BOPBiomes.hell_extension = ModBiomes.registerWrappedBiome(new BiomeExtHell(), "hell");
    }

    private static void registerBiomeDictionaryTags() {
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bamboo_forest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bayou, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.bog, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.boreal_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.brushland, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.chaparral, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cherry_blossom_grove, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.cold_desert, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.DRY, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.coniferous_forest, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.crag, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dead_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.dead_swamp, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.eucalyptus_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fen, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.flower_field, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grassland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.grove, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.highland, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.land_of_lakes, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lavender_fields, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_desert, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.lush_swamp, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mangrove, BiomeDictionary.Type.WATER, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.maple_woods, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.marsh, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.meadow, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.moor, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mountain, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mystic_grove, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.ominous_woods, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.orchard, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.outback, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.overgrown_cliffs, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.prairie, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.quagmire, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.WET);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.rainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.redwood_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.sacred_springs, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.seasonal_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shield, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.shrubland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_coniferous_forest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.snowy_forest, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.steppe, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.temperate_rainforest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropical_rainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tundra, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wasteland, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.wetland, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.woodland, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.xeric_shrubland, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.alps_foothills, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.mountain_foothills, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.glacier, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.COLD);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.oasis, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.coral_reef, BiomeDictionary.Type.WATER, BiomeDictionary.Type.OCEAN);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.kelp_forest, BiomeDictionary.Type.WATER, BiomeDictionary.Type.OCEAN);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.tropical_island, BiomeDictionary.Type.WATER, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.volcanic_island, BiomeDictionary.Type.WATER, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.flower_island, BiomeDictionary.Type.WATER, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.origin_island, BiomeDictionary.Type.WATER, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.gravel_beach, BiomeDictionary.Type.BEACH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.white_beach, BiomeDictionary.Type.BEACH);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.corrupted_sands, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SPOOKY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.fungi_forest, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.DENSE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.phantasmagoric_inferno, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.polar_chasm, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.undergarden, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.JUNGLE);
        ModBiomes.registerBiomeToDictionary(BOPBiomes.visceral_heap, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET);
    }

    public static void registerNetherOverride() {
        DimensionManager.unregisterDimension((int)-1);
        DimensionType netherBOP = DimensionType.register((String)"Nether", (String)"_nether", (int)-1, WorldProviderBOPHell.class, (boolean)false);
        DimensionManager.registerDimension((int)-1, (DimensionType)netherBOP);
    }

    @Override
    public IExtendedBiome registerBiome(IExtendedBiome extendedBiome, String idName) {
        if (extendedBiome == null) {
            throw new IllegalArgumentException("Extended biome to register cannot be null!");
        }
        presentBiomes.add(extendedBiome.getBaseBiome());
        if (extendedBiome instanceof Biome) {
            for (Map.Entry<BOPClimates, Integer> entry : extendedBiome.getWeightMap().entrySet()) {
                if (entry == null) continue;
                BOPClimates climate = entry.getKey();
                int weight = entry.getValue();
                climate.addBiome(weight, extendedBiome.getBaseBiome());
            }
        } else {
            biomeWrapperMap.put(Biome.func_185362_a((Biome)extendedBiome.getBaseBiome()), extendedBiome);
        }
        return extendedBiome;
    }

    @Override
    public IExtendedBiome getExtendedBiome(Biome biome) {
        if (biome instanceof IExtendedBiome) {
            return (IExtendedBiome)biome;
        }
        IExtendedBiome wrapper = biomeWrapperMap.get(Biome.func_185362_a((Biome)biome));
        if (wrapper != null) {
            return wrapper;
        }
        return null;
    }

    @Override
    public ImmutableSet<Biome> getPresentBiomes() {
        return ImmutableSet.copyOf(presentBiomes);
    }

    public static IConfigObj readConfigFile(String idName) {
        File configFile = new File(new File(BiomesOPlenty.configDirectory, "biomes"), idName + ".json");
        BOPConfig.ConfigFileObj conf = new BOPConfig.ConfigFileObj(configFile, false, true);
        return conf;
    }

    public static void writeDefaultConfigFile(File basePath, String idName, IConfigObj conf) {
        File defaultFile = new File(basePath, idName + ".json");
        String json = BOPConfig.serializer.toJson(conf.serializeDefaults());
        try {
            FileUtils.write((File)defaultFile, (CharSequence)json);
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("Could not write default biome config file " + defaultFile.getName());
        }
    }

    private static void setSubBiome(Optional<Biome> parent, Optional<Biome> ... subBiomes) {
        if (parent.isPresent()) {
            for (Optional<Biome> subBiome : subBiomes) {
                if (!subBiome.isPresent()) continue;
                ModBiomes.setSubBiome((Biome)parent.get(), (Biome)subBiome.get());
            }
        }
    }

    private static void setSubBiome(Biome parent, Biome ... subBiomes) {
        Map<Integer, List<Integer>> map = subBiomesMap;
        int parentId = Biome.func_185362_a((Biome)parent);
        if (!map.containsKey(parentId)) {
            map.put(parentId, new ArrayList());
        }
        for (Biome subBiome : subBiomes) {
            map.get(parentId).add(Biome.func_185362_a((Biome)subBiome));
        }
    }

    private static void addIslandBiome(Optional<Biome> biome, int weight) {
        if (biome.isPresent()) {
            totalIslandBiomesWeight += weight;
            islandBiomesMap.put(Biome.func_185362_a((Biome)((Biome)biome.get())), weight);
        }
    }

    private static IExtendedBiome registerWrappedBiome(IExtendedBiome extendedBiome, String idName) {
        if (extendedBiome.getBaseBiome() instanceof IExtendedBiome) {
            throw new IllegalArgumentException("Biome already implements IExtendedBiome, it should be registered appropriately");
        }
        extendedBiome.configure(ModBiomes.readConfigFile(idName));
        return BOPBiomes.REG_INSTANCE.registerBiome(extendedBiome, idName);
    }

    private static Optional<Biome> registerOverworldBiome(BOPOverworldBiome biome) {
        String idName = biome.getResourceLocation().func_110623_a();
        Integer id = biomeIdMapConf.getInt(idName, null);
        if (id == null) {
            id = new Integer(ModBiomes.getNextFreeBiomeId());
        }
        biomeIdMap.put(idName, id);
        if (id > -1) {
            biome.configure(biome.conf);
            ++BOPCommand.biomeCount;
            BOPBiomes.REG_INSTANCE.registerBiome(biome, idName);
            biome.setRegistryName(biome.getResourceLocation());
            ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
            if (biome.canSpawnInBiome) {
                BiomeManager.addSpawnBiome((Biome)biome);
            }
            if (biome.canGenerateVillages) {
                BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
            }
            return Optional.of((Object)biome);
        }
        return Optional.absent();
    }

    private static Optional<Biome> registerNetherBiome(BOPHellBiome biome) {
        String idName = biome.getResourceLocation().func_110623_a();
        Integer id = biomeIdMapConf.getInt(idName, null);
        if (id == null) {
            id = new Integer(ModBiomes.getNextFreeBiomeId());
        }
        biomeIdMap.put(idName, id);
        if (id > -1) {
            biome.configure(biome.conf);
            ++BOPCommand.biomeCount;
            BOPBiomes.REG_INSTANCE.registerBiome(biome, idName);
            biome.setRegistryName(biome.getResourceLocation());
            ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
            return Optional.of((Object)biome);
        }
        return Optional.absent();
    }

    private static void registerBiomeToDictionary(Optional<Biome> biome, BiomeDictionary.Type ... types) {
        if (biome.isPresent()) {
            BiomeDictionary.addTypes((Biome)((Biome)biome.get()), (BiomeDictionary.Type[])types);
        }
    }

    public static int getNextFreeBiomeId() {
        for (int i = nextBiomeId; i < 256; ++i) {
            if (Biome.func_150568_d((int)i) != null) {
                if (i != 255) continue;
                throw new IllegalArgumentException("There are no more biome ids avaliable!");
            }
            if (idsReservedInConfig.contains(i)) continue;
            nextBiomeId = i + 1;
            return i;
        }
        return -1;
    }

    static {
        nextBiomeId = 40;
        islandBiomesMap = new HashMap<Integer, Integer>();
    }
}

