/*
 * Decompiled with CFR 0.152.
 */
package mods.octarinecore.client.render;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mods.octarinecore.Utils;
import mods.octarinecore.client.render.BlockData;
import mods.octarinecore.common.Double3;
import mods.octarinecore.common.GeometryKt;
import mods.octarinecore.common.Int3;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\n \u0015*\u0004\u0018\u00010\b0\b2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!J\u0016\u0010$\u001a\n \u0015*\u0004\u0018\u00010%0%2\u0006\u0010 \u001a\u00020!J\u001a\u0010&\u001a\u00020'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020'0)J\u000e\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004J\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-2\u0006\u0010.\u001a\u00020\u0004\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\"\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00062"}, d2={"Lmods/octarinecore/client/render/BlockContext;", "", "()V", "biomeId", "", "getBiomeId", "()I", "block", "Lnet/minecraft/block/Block;", "getBlock", "()Lnet/minecraft/block/Block;", "blockCenter", "Lmods/octarinecore/common/Double3;", "getBlockCenter", "()Lmods/octarinecore/common/Double3;", "cameraDistance", "getCameraDistance", "chunkBase", "getChunkBase", "pos", "Lnet/minecraft/util/math/BlockPos;", "kotlin.jvm.PlatformType", "getPos", "()Lnet/minecraft/util/math/BlockPos;", "setPos", "(Lnet/minecraft/util/math/BlockPos;)V", "world", "Lnet/minecraft/world/IBlockAccess;", "getWorld", "()Lnet/minecraft/world/IBlockAccess;", "setWorld", "(Lnet/minecraft/world/IBlockAccess;)V", "offset", "Lmods/octarinecore/common/Int3;", "blockData", "Lmods/octarinecore/client/render/BlockData;", "blockState", "Lnet/minecraft/block/state/IBlockState;", "isSurroundedBy", "", "predicate", "Lkotlin/Function1;", "random", "seed", "semiRandomArray", "", "num", "(I)[Ljava/lang/Integer;", "set", "", "BetterFoliage_main"})
public final class BlockContext {
    @Nullable
    private IBlockAccess world;
    private BlockPos pos = BlockPos.field_177992_a;

    @Nullable
    public final IBlockAccess getWorld() {
        return this.world;
    }

    public final void setWorld(@Nullable IBlockAccess iBlockAccess) {
        this.world = iBlockAccess;
    }

    public final BlockPos getPos() {
        return this.pos;
    }

    public final void setPos(BlockPos blockPos) {
        this.pos = blockPos;
    }

    public final void set(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        this.world = world;
        this.pos = pos;
    }

    @NotNull
    public final Block getBlock() {
        Block block = this.block(Int3.Companion.getZero());
        Intrinsics.checkExpressionValueIsNotNull(block, "block(Int3.zero)");
        return block;
    }

    public final Block block(@NotNull Int3 offset) {
        Intrinsics.checkParameterIsNotNull(offset, "offset");
        return this.blockState(offset).func_177230_c();
    }

    public final IBlockState blockState(@NotNull Int3 offset) {
        BlockPos blockPos;
        Intrinsics.checkParameterIsNotNull(offset, "offset");
        BlockPos it = blockPos = GeometryKt.plus(this.pos, offset);
        IBlockAccess iBlockAccess = this.world;
        if (iBlockAccess == null) {
            Intrinsics.throwNpe();
        }
        return iBlockAccess.func_180495_p(it);
    }

    @NotNull
    public final BlockData blockData(@NotNull Int3 offset) {
        IBlockState iBlockState;
        IBlockState state;
        BlockPos blockPos;
        Intrinsics.checkParameterIsNotNull(offset, "offset");
        BlockPos pos = blockPos = GeometryKt.plus(this.pos, offset);
        IBlockAccess iBlockAccess = this.world;
        if (iBlockAccess == null) {
            Intrinsics.throwNpe();
        }
        IBlockState iBlockState2 = state = (iBlockState = iBlockAccess.func_180495_p(pos));
        Intrinsics.checkExpressionValueIsNotNull(iBlockState2, "state");
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        IBlockAccess iBlockAccess2 = this.world;
        if (iBlockAccess2 == null) {
            Intrinsics.throwNpe();
        }
        int n = blockColors.func_186724_a(state, iBlockAccess2, pos, 0);
        Block block = state.func_177230_c();
        IBlockAccess iBlockAccess3 = this.world;
        if (iBlockAccess3 == null) {
            Intrinsics.throwNpe();
        }
        return new BlockData(iBlockState2, n, block.func_185484_c(state, iBlockAccess3, pos));
    }

    public final int getBiomeId() {
        IBlockAccess iBlockAccess = this.world;
        if (iBlockAccess == null) {
            Intrinsics.throwNpe();
        }
        return Biome.func_185362_a((Biome)iBlockAccess.func_180494_b(this.pos));
    }

    @NotNull
    public final Double3 getBlockCenter() {
        return new Double3((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
    }

    @NotNull
    public final Double3 getChunkBase() {
        int cX = this.pos.func_177958_n() >= 0 ? this.pos.func_177958_n() / 16 : (this.pos.func_177958_n() + 1) / 16 - 1;
        int cY = this.pos.func_177956_o() / 16;
        int cZ = this.pos.func_177952_p() >= 0 ? this.pos.func_177952_p() / 16 : (this.pos.func_177952_p() + 1) / 16 - 1;
        return new Double3((double)cX * 16.0, (double)cY * 16.0, (double)cZ * 16.0);
    }

    public final boolean isSurroundedBy(@NotNull Function1<? super IBlockState, Boolean> predicate) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(predicate, "predicate");
            Iterable $receiver$iv = GeometryKt.getForgeDirOffsets();
            for (Object element$iv : $receiver$iv) {
                Int3 it = (Int3)element$iv;
                IBlockState iBlockState = this.blockState(it);
                Intrinsics.checkExpressionValueIsNotNull(iBlockState, "blockState(it)");
                if (predicate.invoke((IBlockState)iBlockState).booleanValue()) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public final int random(int seed) {
        return Utils.semiRandom(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), seed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Integer[] semiRandomArray(int num) {
        Integer[] result$iv = new Integer[num];
        int n = 0;
        int n2 = num - 1;
        if (n <= n2) {
            void i$iv;
            do {
                void it;
                Integer n3;
                void var5_5 = ++i$iv;
                void var9_7 = i$iv;
                Integer[] integerArray = result$iv;
                integerArray[var9_7] = n3 = Integer.valueOf(this.random((int)it));
            } while (i$iv != n2);
        }
        return (Integer[])((Object[])result$iv);
    }

    public final int getCameraDistance() {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity == null) {
            return 0;
        }
        Entity camera = entity;
        return Math.abs(this.pos.func_177958_n() - MathHelper.func_76128_c((double)camera.field_70165_t)) + Math.abs(this.pos.func_177956_o() - MathHelper.func_76128_c((double)camera.field_70163_u)) + Math.abs(this.pos.func_177952_p() - MathHelper.func_76128_c((double)camera.field_70161_v));
    }
}

